/*
 * Copyright 2014-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.keyvalue.repository.support;

import java.util.Optional;
import java.util.function.Function;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.Assert;

import com.querydsl.collections.CollQuery;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;

/**
 * {@link KeyValueRepository} implementation capable of executing {@link Predicate}s using {@link CollQuery}.
 *
 * @author Christoph Strobl
 * @author Oliver Gierke
 * @author Thomas Darimont
 * @author Mark Paluch
 * @param <T> the domain type to manage
 * @param <ID> the identifier type of the domain type
 * @deprecated since 2.6, use {@link QuerydslKeyValuePredicateExecutor} instead.
 */
@Deprecated
public class QuerydslKeyValueRepository<T, ID> extends SimpleKeyValueRepository<T, ID>
		implements QuerydslPredicateExecutor<T> {

	private final QuerydslKeyValuePredicateExecutor<T> executor;

	/**
	 * Creates a new {@link QuerydslKeyValueRepository} for the given {@link EntityInformation} and
	 * {@link KeyValueOperations}.
	 *
	 * @param entityInformation must not be {@literal null}.
	 * @param operations must not be {@literal null}.
	 */
	public QuerydslKeyValueRepository(EntityInformation<T, ID> entityInformation, KeyValueOperations operations) {
		this(entityInformation, operations, SimpleEntityPathResolver.INSTANCE);
	}

	/**
	 * Creates a new {@link QuerydslKeyValueRepository} for the given {@link EntityInformation},
	 * {@link KeyValueOperations} and {@link EntityPathResolver}.
	 *
	 * @param entityInformation must not be {@literal null}.
	 * @param operations must not be {@literal null}.
	 * @param resolver must not be {@literal null}.
	 */
	public QuerydslKeyValueRepository(EntityInformation<T, ID> entityInformation, KeyValueOperations operations,
			EntityPathResolver resolver) {

		super(entityInformation, operations);

		Assert.notNull(resolver, "EntityPathResolver must not be null");

		this.executor = new QuerydslKeyValuePredicateExecutor<>(entityInformation, new SpelAwareProxyProjectionFactory(),
				operations, resolver);
	}

	@Override
	public Optional<T> findOne(Predicate predicate) {
		return executor.findOne(predicate);
	}

	@Override
	public Iterable<T> findAll(Predicate predicate) {
		return executor.findAll(predicate);
	}

	@Override
	public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?>... orders) {
		return executor.findAll(predicate, orders);
	}

	@Override
	public Iterable<T> findAll(Predicate predicate, Sort sort) {
		return executor.findAll(predicate, sort);
	}

	@Override
	public Page<T> findAll(Predicate predicate, Pageable pageable) {
		return executor.findAll(predicate, pageable);
	}

	@Override
	public Iterable<T> findAll(OrderSpecifier<?>... orders) {
		return executor.findAll(orders);
	}

	@Override
	public long count(Predicate predicate) {
		return executor.count(predicate);
	}

	@Override
	public boolean exists(Predicate predicate) {
		return executor.exists(predicate);
	}

	@Override
	public <S extends T, R> R findBy(Predicate predicate,
			Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
		return executor.findBy(predicate, queryFunction);
	}

}
