/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.Name;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Persistable;
import org.springframework.data.ldap.repository.LdapRepository;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.support.CountNameClassPairCallbackHandler;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

public class SimpleLdapRepository<T>
implements LdapRepository<T> {
    private static final String OBJECTCLASS_ATTRIBUTE = "objectclass";
    private final LdapOperations ldapOperations;
    private final ObjectDirectoryMapper odm;
    private final Class<T> entityType;

    public SimpleLdapRepository(LdapOperations ldapOperations, ObjectDirectoryMapper odm, Class<T> entityType) {
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null!");
        Assert.notNull((Object)odm, (String)"ObjectDirectoryMapper must not be null!");
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        this.ldapOperations = ldapOperations;
        this.odm = odm;
        this.entityType = entityType;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Name declaredId = this.odm.getId(entity);
        if (this.isNew(entity, declaredId)) {
            this.ldapOperations.create(entity);
        } else {
            this.ldapOperations.update(entity);
        }
        return entity;
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return StreamSupport.stream(entities.spliterator(), false).map(this::save).collect(Collectors.toList());
    }

    public Optional<T> findById(Name name) {
        Assert.notNull((Object)name, (String)"Id must not be null");
        try {
            return Optional.ofNullable(this.ldapOperations.findByDn(name, this.entityType));
        }
        catch (NameNotFoundException e) {
            return Optional.empty();
        }
    }

    public boolean existsById(Name name) {
        Assert.notNull((Object)name, (String)"Id must not be null");
        return this.findById(name).isPresent();
    }

    @Override
    public List<T> findAll() {
        return this.ldapOperations.findAll(this.entityType);
    }

    @Override
    public List<T> findAllById(Iterable<Name> names) {
        return StreamSupport.stream(names.spliterator(), false).map(this::findById).flatMap(xva$0 -> Optionals.toStream((Optional[])new Optional[]{xva$0})).collect(Collectors.toList());
    }

    public long count() {
        Filter filter = this.odm.filterFor(this.entityType, null);
        CountNameClassPairCallbackHandler callback = new CountNameClassPairCallbackHandler();
        LdapQuery query = LdapQueryBuilder.query().attributes(new String[]{OBJECTCLASS_ATTRIBUTE}).filter(filter);
        this.ldapOperations.search(query, (NameClassPairCallbackHandler)callback);
        return callback.getNoOfRows();
    }

    public void deleteById(Name name) {
        Assert.notNull((Object)name, (String)"Id must not be null");
        this.ldapOperations.unbind(name);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        this.ldapOperations.delete(entity);
    }

    public void deleteAllById(Iterable<? extends Name> names) {
        Assert.notNull(names, (String)"Names must not be null.");
        names.forEach(this::deleteById);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null.");
        entities.forEach(this::delete);
    }

    public void deleteAll() {
        this.deleteAll(this.findAll());
    }

    @Override
    public Optional<T> findOne(LdapQuery ldapQuery) {
        Assert.notNull((Object)ldapQuery, (String)"LdapQuery must not be null");
        try {
            return Optional.ofNullable(this.ldapOperations.findOne(ldapQuery, this.entityType));
        }
        catch (EmptyResultDataAccessException e) {
            return Optional.empty();
        }
    }

    @Override
    public List<T> findAll(LdapQuery ldapQuery) {
        Assert.notNull((Object)ldapQuery, (String)"LdapQuery must not be null");
        return this.ldapOperations.find(ldapQuery, this.entityType);
    }

    private <S extends T> boolean isNew(S entity, @Nullable Name id) {
        if (entity instanceof Persistable) {
            Persistable persistable = (Persistable)entity;
            return persistable.isNew();
        }
        return id == null;
    }
}

