/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository;

import org.springframework.util.ObjectUtils;

public interface LdapEncoder {
    public String encode(String var1);

    public static class LikeEncoder
    implements LdapEncoder {
        @Override
        public String encode(String value) {
            if (ObjectUtils.isEmpty((Object)value)) {
                return value;
            }
            String[] substrings = value.split("\\*", -2);
            if (substrings.length == 1) {
                return org.springframework.ldap.support.LdapEncoder.filterEncode((String)substrings[0]);
            }
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < substrings.length; ++i) {
                buff.append(org.springframework.ldap.support.LdapEncoder.filterEncode((String)substrings[i]));
                if (i >= substrings.length - 1) continue;
                buff.append("*");
            }
            return buff.toString();
        }
    }

    public static class NameEncoder
    implements LdapEncoder {
        @Override
        public String encode(String value) {
            return org.springframework.ldap.support.LdapEncoder.nameEncode((String)value);
        }
    }
}

