/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.GeoResult;
import org.springframework.data.mongodb.core.geo.GeoResults;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private final MongoQueryMethod method;
    private final MongoOperations mongoOperations;

    public AbstractMongoQuery(MongoQueryMethod method, MongoOperations template) {
        Assert.notNull((Object)template);
        Assert.notNull((Object)((Object)method));
        this.method = method;
        this.mongoOperations = template;
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        MongoParametersParameterAccessor accessor = new MongoParametersParameterAccessor(this.method, parameters);
        Query query = this.createQuery(new ConvertingParameterAccessor(this.mongoOperations.getConverter(), accessor));
        if (this.method.isGeoNearQuery()) {
            return new GeoNearExecution(accessor).execute(query);
        }
        if (this.method.isCollectionQuery()) {
            return new CollectionExecution().execute(query);
        }
        if (this.method.isPageQuery()) {
            return new PagedExecution(accessor.getPageable()).execute(query);
        }
        return new SingleEntityExecution().execute(query);
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    class GeoNearExecution
    extends Execution {
        private final MongoParameterAccessor accessor;

        public GeoNearExecution(MongoParameterAccessor accessor) {
            this.accessor = accessor;
        }

        Object execute(Query query) {
            Distance maxDistance;
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            if ((maxDistance = this.accessor.getMaxDistance()) != null) {
                nearQuery.maxDistance(maxDistance);
            }
            MongoEntityInformation<?, ?> entityInformation = AbstractMongoQuery.this.method.getEntityInformation();
            GeoResults results = AbstractMongoQuery.this.mongoOperations.geoNear(nearQuery, entityInformation.getJavaType(), entityInformation.getCollectionName());
            return this.isListOfGeoResult() ? results.getContent() : results;
        }

        private boolean isListOfGeoResult() {
            TypeInformation<?> returnType = AbstractMongoQuery.this.method.getReturnType();
            return returnType.getType().equals(List.class) && GeoResult.class.equals((Object)returnType.getComponentType());
        }
    }

    class SingleEntityExecution
    extends Execution {
        SingleEntityExecution() {
        }

        Object execute(Query query) {
            MongoEntityInformation<?, ?> entityInformation = AbstractMongoQuery.this.method.getEntityInformation();
            return AbstractMongoQuery.this.mongoOperations.findOne(query, entityInformation.getJavaType());
        }
    }

    class PagedExecution
    extends Execution {
        private final Pageable pageable;

        public PagedExecution(Pageable pageable) {
            Assert.notNull((Object)pageable);
            this.pageable = pageable;
        }

        Object execute(Query query) {
            MongoEntityInformation<?, ?> metadata = AbstractMongoQuery.this.method.getEntityInformation();
            int count = this.getCollectionCursor(metadata.getCollectionName(), query.getQueryObject()).count();
            List result = AbstractMongoQuery.this.mongoOperations.find(QueryUtils.applyPagination(query, this.pageable), metadata.getJavaType(), metadata.getCollectionName());
            return new PageImpl(result, this.pageable, (long)count);
        }

        private DBCursor getCollectionCursor(String collectionName, final DBObject query) {
            return AbstractMongoQuery.this.mongoOperations.execute(collectionName, new CollectionCallback<DBCursor>(){

                @Override
                public DBCursor doInCollection(DBCollection collection) {
                    return collection.find(query);
                }
            });
        }
    }

    class CollectionExecution
    extends Execution {
        CollectionExecution() {
        }

        public Object execute(Query query) {
            return this.readCollection(query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Execution {
        private Execution() {
        }

        abstract Object execute(Query var1);

        protected List<?> readCollection(Query query) {
            MongoEntityInformation<?, ?> metadata = AbstractMongoQuery.this.method.getEntityInformation();
            String collectionName = metadata.getCollectionName();
            return AbstractMongoQuery.this.mongoOperations.find(query, metadata.getJavaType(), collectionName);
        }
    }
}

