/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryCreator;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeMongoQuery
extends AbstractMongoQuery {
    private final PartTree tree;
    private final boolean isGeoNearQuery;
    private final MappingContext<?, MongoPersistentProperty> context;

    public PartTreeMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations) {
        super(method, mongoOperations);
        this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
        this.isGeoNearQuery = method.isGeoNearQuery();
        this.context = mongoOperations.getConverter().getMappingContext();
    }

    public PartTree getTree() {
        return this.tree;
    }

    protected Query createQuery(ConvertingParameterAccessor accessor) {
        MongoQueryCreator creator = new MongoQueryCreator(this.tree, accessor, this.context, this.isGeoNearQuery);
        return (Query)creator.createQuery();
    }
}

