/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ServerAddress;
import java.beans.PropertyEditorSupport;
import java.net.UnknownHostException;
import org.springframework.util.StringUtils;

public class ServerAddressPropertyEditor
extends PropertyEditorSupport {
    public void setAsText(String replicaSetString) {
        String[] replicaSetStringArray = StringUtils.commaDelimitedListToStringArray((String)replicaSetString);
        ServerAddress[] serverAddresses = new ServerAddress[replicaSetStringArray.length];
        for (int i = 0; i < replicaSetStringArray.length; ++i) {
            String[] hostAndPort = StringUtils.delimitedListToStringArray((String)replicaSetStringArray[i], (String)":");
            try {
                serverAddresses[i] = new ServerAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse port " + hostAndPort[1], e);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Could not parse host " + hostAndPort[0], e);
            }
        }
        this.setValue(serverAddresses);
    }
}

