/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;

public class StringBasedMongoQuery
extends AbstractMongoQuery {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private static final Log LOG = LogFactory.getLog(StringBasedMongoQuery.class);
    private final String query;
    private final String fieldSpec;

    public StringBasedMongoQuery(String query, MongoQueryMethod method, MongoOperations mongoOperations) {
        super(method, mongoOperations);
        this.query = query;
        this.fieldSpec = method.getFieldSpecification();
    }

    public StringBasedMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations) {
        this(method.getAnnotatedQuery(), method, mongoOperations);
    }

    protected Query createQuery(ConvertingParameterAccessor accessor) {
        String queryString = this.replacePlaceholders(this.query, accessor);
        BasicQuery query = null;
        if (this.fieldSpec != null) {
            String fieldString = this.replacePlaceholders(this.fieldSpec, accessor);
            query = new BasicQuery(queryString, fieldString);
        } else {
            query = new BasicQuery(queryString);
        }
        QueryUtils.applySorting(query, accessor.getSort());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created query %s", ((Query)query).getQueryObject()));
        }
        return query;
    }

    private String replacePlaceholders(String input, ConvertingParameterAccessor accessor) {
        Matcher matcher = PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            result = result.replace(group, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    private String getParameterWithIndex(ConvertingParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        if (parameter == null) {
            return "null";
        }
        if (parameter instanceof String || parameter.getClass().isEnum()) {
            return String.format("\"%s\"", parameter);
        }
        if (parameter instanceof ObjectId) {
            return String.format("{ '$oid' : '%s' }", parameter);
        }
        return parameter.toString();
    }
}

