/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ReflectiveDBRefResolver {
    private static final Method FETCH_METHOD = ReflectionUtils.findMethod(DBRef.class, (String)"fetch");

    ReflectiveDBRefResolver() {
    }

    public static DBObject fetch(MongoDbFactory factory, DBRef ref) {
        Assert.notNull((Object)ref, (String)"DBRef to fetch must not be null!");
        if (MongoClientVersion.isMongo3Driver()) {
            Assert.notNull((Object)factory, (String)"DbFactory to fetch DB from must not be null!");
            return factory.getDb().getCollection(ref.getCollectionName()).findOne(ref.getId());
        }
        return (DBObject)ReflectionUtils.invokeMethod((Method)FETCH_METHOD, (Object)ref);
    }
}

