/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.ObjectUtils;

class AggregationUtil {
    QueryMapper queryMapper;
    MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    AggregationOperationContext prepareAggregationContext(Aggregation aggregation, AggregationOperationContext context) {
        if (context != null) {
            return context;
        }
        if (aggregation instanceof TypedAggregation) {
            return new TypeBasedAggregationOperationContext(((TypedAggregation)aggregation).getInputType(), this.mappingContext, this.queryMapper);
        }
        return Aggregation.DEFAULT_CONTEXT;
    }

    DBObject createPipeline(String collectionName, Aggregation aggregation, AggregationOperationContext context) {
        if (!ObjectUtils.nullSafeEquals((Object)context, (Object)Aggregation.DEFAULT_CONTEXT)) {
            return aggregation.toDbObject(collectionName, context);
        }
        DBObject command = aggregation.toDbObject(collectionName, context);
        command.put("pipeline", (Object)this.mapAggregationPipeline((List)command.get("pipeline")));
        return command;
    }

    DBObject createCommand(String collection, Aggregation aggregation, AggregationOperationContext context) {
        DBObject command = aggregation.toDbObject(collection, context);
        if (!ObjectUtils.nullSafeEquals((Object)context, (Object)Aggregation.DEFAULT_CONTEXT)) {
            return command;
        }
        command.put("pipeline", (Object)this.mapAggregationPipeline((List)command.get("pipeline")));
        return command;
    }

    private BasicDBList mapAggregationPipeline(List<DBObject> pipeline) {
        BasicDBList mapped = new BasicDBList();
        for (DBObject stage : pipeline) {
            mapped.add((Object)this.queryMapper.getMappedObject(stage, null));
        }
        return mapped;
    }

    public AggregationUtil(QueryMapper queryMapper, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.queryMapper = queryMapper;
        this.mappingContext = mappingContext;
    }
}

