/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.mapreduce.MapReduceCounts;
import org.springframework.data.mongodb.core.mapreduce.MapReduceTiming;
import org.springframework.util.Assert;

public class MapReduceResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private final DBObject rawResults;
    private final String outputCollection;
    private final MapReduceTiming mapReduceTiming;
    private final MapReduceCounts mapReduceCounts;

    @Deprecated
    public MapReduceResults(List<T> mappedResults, DBObject rawResults) {
        Assert.notNull(mappedResults, (String)"List of mapped results must not be null!");
        Assert.notNull((Object)rawResults, (String)"Raw results must not be null!");
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.mapReduceTiming = MapReduceResults.parseTiming(rawResults);
        this.mapReduceCounts = MapReduceResults.parseCounts(rawResults);
        this.outputCollection = MapReduceResults.parseOutputCollection(rawResults);
    }

    public MapReduceResults(List<T> mappedResults, MapReduceOutput mapReduceOutput) {
        Assert.notNull(mappedResults, (String)"MappedResults must not be null!");
        Assert.notNull((Object)mapReduceOutput, (String)"MapReduceOutput must not be null!");
        this.mappedResults = mappedResults;
        this.rawResults = null;
        this.mapReduceTiming = MapReduceResults.parseTiming(mapReduceOutput);
        this.mapReduceCounts = MapReduceResults.parseCounts(mapReduceOutput);
        this.outputCollection = MapReduceResults.parseOutputCollection(mapReduceOutput);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public MapReduceTiming getTiming() {
        return this.mapReduceTiming;
    }

    public MapReduceCounts getCounts() {
        return this.mapReduceCounts;
    }

    public String getOutputCollection() {
        return this.outputCollection;
    }

    public DBObject getRawResults() {
        return this.rawResults;
    }

    private static MapReduceTiming parseTiming(DBObject rawResults) {
        DBObject timing = (DBObject)rawResults.get("timing");
        if (timing == null) {
            return new MapReduceTiming(-1L, -1L, -1L);
        }
        if (timing.get("mapTime") != null && timing.get("emitLoop") != null && timing.get("total") != null) {
            return new MapReduceTiming(MapReduceResults.getAsLong(timing, "mapTime"), MapReduceResults.getAsLong(timing, "emitLoop"), MapReduceResults.getAsLong(timing, "total"));
        }
        return new MapReduceTiming(-1L, -1L, -1L);
    }

    private static Long getAsLong(DBObject source, String key) {
        Object raw = source.get(key);
        return raw instanceof Long ? (Long)raw : (long)((Integer)raw).intValue();
    }

    private static MapReduceCounts parseCounts(DBObject rawResults) {
        DBObject counts = (DBObject)rawResults.get("counts");
        if (counts == null) {
            return MapReduceCounts.NONE;
        }
        if (counts.get("input") != null && counts.get("emit") != null && counts.get("output") != null) {
            return new MapReduceCounts(MapReduceResults.getAsLong(counts, "input"), MapReduceResults.getAsLong(counts, "emit"), MapReduceResults.getAsLong(counts, "output"));
        }
        return MapReduceCounts.NONE;
    }

    private static String parseOutputCollection(DBObject rawResults) {
        Object resultField = rawResults.get("result");
        if (resultField == null) {
            return null;
        }
        return resultField instanceof DBObject ? ((DBObject)resultField).get("collection").toString() : resultField.toString();
    }

    private static MapReduceCounts parseCounts(MapReduceOutput mapReduceOutput) {
        return new MapReduceCounts(mapReduceOutput.getInputCount(), mapReduceOutput.getEmitCount(), mapReduceOutput.getOutputCount());
    }

    private static String parseOutputCollection(MapReduceOutput mapReduceOutput) {
        return mapReduceOutput.getCollectionName();
    }

    private static MapReduceTiming parseTiming(MapReduceOutput mapReduceOutput) {
        return new MapReduceTiming(-1L, -1L, mapReduceOutput.getDuration());
    }
}

