/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;

class AggregationOperationRenderer {
    static final AggregationOperationContext DEFAULT_CONTEXT = new NoOpAggregationOperationContext();

    AggregationOperationRenderer() {
    }

    static List<DBObject> toDBObject(List<AggregationOperation> operations, AggregationOperationContext rootContext) {
        ArrayList<DBObject> operationDocuments = new ArrayList<DBObject>(operations.size());
        AggregationOperationContext contextToUse = rootContext;
        for (AggregationOperation operation : operations) {
            operationDocuments.add(operation.toDBObject(contextToUse));
            if (!(operation instanceof FieldsExposingAggregationOperation)) continue;
            FieldsExposingAggregationOperation exposedFieldsOperation = (FieldsExposingAggregationOperation)operation;
            ExposedFields fields = exposedFieldsOperation.getFields();
            if (operation instanceof FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation || exposedFieldsOperation.inheritsFields()) {
                contextToUse = new InheritingExposedFieldsAggregationOperationContext(fields, contextToUse);
                continue;
            }
            contextToUse = fields.exposesNoFields() ? DEFAULT_CONTEXT : new ExposedFieldsAggregationOperationContext(exposedFieldsOperation.getFields(), contextToUse);
        }
        return operationDocuments;
    }

    private static class NoOpAggregationOperationContext
    implements AggregationOperationContext {
        private NoOpAggregationOperationContext() {
        }

        @Override
        public DBObject getMappedObject(DBObject dbObject) {
            return dbObject;
        }

        @Override
        public ExposedFields.FieldReference getReference(Field field) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(field, true));
        }

        @Override
        public ExposedFields.FieldReference getReference(String name) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(new Fields.AggregationField(name), true));
        }
    }
}

