/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;

class NestedDelegatingExpressionAggregationOperationContext
implements AggregationOperationContext {
    private final AggregationOperationContext delegate;

    public NestedDelegatingExpressionAggregationOperationContext(AggregationOperationContext referenceContext) {
        Assert.notNull((Object)referenceContext, (String)"Reference context must not be null!");
        this.delegate = referenceContext;
    }

    @Override
    public DBObject getMappedObject(DBObject dbObject) {
        return this.delegate.getMappedObject(dbObject);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return new ExposedFields.ExpressionFieldReference(this.delegate.getReference(field));
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return new ExposedFields.ExpressionFieldReference(this.delegate.getReference(name));
    }
}

