/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation;
import org.springframework.data.mongodb.repository.support.PersistableMongoEntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class MongoEntityInformationSupport {
    private MongoEntityInformationSupport() {
    }

    static <T, ID extends Serializable> MongoEntityInformation<T, ID> entityInformationFor(MongoPersistentEntity<?> entity, Class<?> idType) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        MappingMongoEntityInformation entityInformation = new MappingMongoEntityInformation(entity, idType);
        return ClassUtils.isAssignable(Persistable.class, (Class)entity.getType()) ? new PersistableMongoEntityInformation(entityInformation) : entityInformation;
    }
}

