/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditingEventListener
implements ApplicationListener<BeforeConvertEvent<Object>> {
    private final IsNewAwareAuditingHandler<Object> auditingHandler;

    public AuditingEventListener(IsNewAwareAuditingHandler<Object> auditingHandler) {
        Assert.notNull(auditingHandler, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandler = auditingHandler;
    }

    public void onApplicationEvent(BeforeConvertEvent<Object> event) {
        Object entity = event.getSource();
        this.auditingHandler.markAudited(entity);
    }
}

