/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Order;

public class Index
implements IndexDefinition {
    private final Map<String, Sort.Direction> fieldSpec = new LinkedHashMap<String, Sort.Direction>();
    private String name;
    private boolean unique = false;
    private boolean dropDuplicates = false;
    private boolean sparse = false;

    public Index() {
    }

    public Index(String key, Sort.Direction direction) {
        this.fieldSpec.put(key, direction);
    }

    @Deprecated
    public Index(String key, Order order) {
        this(key, order.toDirection());
    }

    @Deprecated
    public Index on(String key, Order order) {
        return this.on(key, order.toDirection());
    }

    public Index on(String key, Sort.Direction direction) {
        this.fieldSpec.put(key, direction);
        return this;
    }

    public Index named(String name) {
        this.name = name;
        return this;
    }

    public Index unique() {
        this.unique = true;
        return this;
    }

    public Index sparse() {
        this.sparse = true;
        return this;
    }

    public Index unique(Duplicates duplicates) {
        if (duplicates == Duplicates.DROP) {
            this.dropDuplicates = true;
        }
        return this.unique();
    }

    @Override
    public DBObject getIndexKeys() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.fieldSpec.keySet()) {
            dbo.put(k, (Object)(this.fieldSpec.get(k).equals((Object)Sort.Direction.ASC) ? 1 : -1));
        }
        return dbo;
    }

    @Override
    public DBObject getIndexOptions() {
        if (this.name == null && !this.unique) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        if (this.name != null) {
            dbo.put("name", (Object)this.name);
        }
        if (this.unique) {
            dbo.put("unique", (Object)true);
        }
        if (this.dropDuplicates) {
            dbo.put("dropDups", (Object)true);
        }
        if (this.sparse) {
            dbo.put("sparse", (Object)true);
        }
        return dbo;
    }

    public String toString() {
        return String.format("Index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }

    public static enum Duplicates {
        RETAIN,
        DROP;

    }
}

