/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.Mongo;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.core.MongoAdminOperations;
import org.springframework.data.mongodb.core.MongoDbUtils;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;

@ManagedResource(description="Mongo Admin Operations")
public class MongoAdmin
implements MongoAdminOperations {
    private final Mongo mongo;
    private String username;
    private String password;

    public MongoAdmin(Mongo mongo) {
        Assert.notNull((Object)mongo);
        this.mongo = mongo;
    }

    @Override
    @ManagedOperation
    public void dropDatabase(String databaseName) {
        this.getDB(databaseName).dropDatabase();
    }

    @Override
    @ManagedOperation
    public void createDatabase(String databaseName) {
        this.getDB(databaseName);
    }

    @Override
    @ManagedOperation
    public String getDatabaseStats(String databaseName) {
        return this.getDB(databaseName).getStats().toString();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    DB getDB(String databaseName) {
        return MongoDbUtils.getDB(this.mongo, databaseName, new UserCredentials(this.username, this.password));
    }
}

