/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.Arrays;
import java.util.Iterator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    private final MongoWriter<?> converter;

    public UpdateMapper(MongoConverter converter) {
        super(converter);
        this.converter = converter;
    }

    @Override
    protected Object delegateConvertToMongoType(Object source, MongoPersistentEntity<?> entity) {
        return entity == null ? super.delegateConvertToMongoType(source, null) : this.converter.convertToMongoType(source, entity.getTypeInformation());
    }

    @Override
    protected QueryMapper.Field createPropertyField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        return entity == null ? super.createPropertyField(entity, key, mappingContext) : new MetadataBackedUpdateField(entity, key, mappingContext);
    }

    private static class MetadataBackedUpdateField
    extends QueryMapper.MetadataBackedField {
        private final String key;

        public MetadataBackedUpdateField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super(key.replaceAll("\\.\\$", ""), entity, mappingContext);
            this.key = key;
        }

        @Override
        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return new UpdatePropertyConverter(this.key);
        }

        private static class UpdatePropertyConverter
        implements Converter<MongoPersistentProperty, String> {
            private final Iterator<String> iterator;

            public UpdatePropertyConverter(String updateKey) {
                Assert.hasText((String)updateKey, (String)"Update key must not be null or empty!");
                this.iterator = Arrays.asList(updateKey.split("\\.")).iterator();
                this.iterator.next();
            }

            public String convert(MongoPersistentProperty property) {
                String mappedName = MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE.convert(property);
                return this.iterator.hasNext() && this.iterator.next().equals("$") ? String.format("%s.$", mappedName) : mappedName;
            }
        }
    }
}

