/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.Assert;

public class MongoPersistentEntityIndexCreator
implements ApplicationListener<MappingContextEvent<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPersistentEntityIndexCreator.class);
    private final Map<Class<?>, Boolean> classesSeen = new ConcurrentHashMap();
    private final MongoDbFactory mongoDbFactory;
    private final MongoMappingContext mappingContext;
    private final IndexResolver indexResolver;

    public MongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, MongoDbFactory mongoDbFactory) {
        this(mappingContext, mongoDbFactory, new MongoPersistentEntityIndexResolver(mappingContext));
    }

    public MongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, MongoDbFactory mongoDbFactory, IndexResolver indexResolver) {
        Assert.notNull((Object)mongoDbFactory);
        Assert.notNull((Object)((Object)mappingContext));
        Assert.notNull((Object)indexResolver);
        this.mongoDbFactory = mongoDbFactory;
        this.mappingContext = mappingContext;
        this.indexResolver = indexResolver;
        for (MongoPersistentEntity entity : mappingContext.getPersistentEntities()) {
            this.checkForIndexes(entity);
        }
    }

    public void onApplicationEvent(MappingContextEvent<?, ?> event) {
        if (!event.wasEmittedBy((MappingContext)this.mappingContext)) {
            return;
        }
        PersistentEntity entity = event.getPersistentEntity();
        if (entity instanceof MongoPersistentEntity) {
            this.checkForIndexes((MongoPersistentEntity)entity);
        }
    }

    private void checkForIndexes(MongoPersistentEntity<?> entity) {
        Class type = entity.getType();
        if (!this.classesSeen.containsKey(type)) {
            this.classesSeen.put(type, Boolean.TRUE);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyzing class " + type + " for index information.");
            }
            this.checkForAndCreateIndexes(entity);
        }
    }

    private void checkForAndCreateIndexes(MongoPersistentEntity<?> entity) {
        if (entity.findAnnotation(Document.class) != null) {
            for (MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinitionHolder : this.indexResolver.resolveIndexForClass(entity.getType())) {
                this.createIndex(indexDefinitionHolder);
            }
        }
    }

    private void createIndex(MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinition) {
        this.mongoDbFactory.getDb().getCollection(indexDefinition.getCollection()).createIndex(indexDefinition.getIndexKeys(), indexDefinition.getIndexOptions());
    }

    public boolean isIndexCreatorFor(MappingContext<?, ?> context) {
        return ((Object)((Object)this.mappingContext)).equals(context);
    }
}

