/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.MongoCredential;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class MongoCredentialPropertyEditor
extends PropertyEditorSupport {
    private static final String AUTH_MECHANISM_KEY = "uri.authMechanism";
    private static final String USERNAME_PASSWORD_DELIMINATOR = ":";
    private static final String DATABASE_DELIMINATOR = "@";
    private static final String OPTIONS_DELIMINATOR = "?";
    private static final String OPTION_VALUE_DELIMINATOR = "&";

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)text)) {
            return;
        }
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        for (String credentialString : text.split(",")) {
            if (!text.contains(USERNAME_PASSWORD_DELIMINATOR) || !text.contains(DATABASE_DELIMINATOR)) {
                throw new IllegalArgumentException("Credentials need to be in format 'username:password@database'!");
            }
            String[] userNameAndPassword = MongoCredentialPropertyEditor.extractUserNameAndPassword(credentialString);
            String database = MongoCredentialPropertyEditor.extractDB(credentialString);
            Properties options = MongoCredentialPropertyEditor.extractOptions(credentialString);
            if (!options.isEmpty()) {
                if (!options.containsKey(AUTH_MECHANISM_KEY)) continue;
                String authMechanism = options.getProperty(AUTH_MECHANISM_KEY);
                if ("GSSAPI".equals(authMechanism)) {
                    credentials.add(MongoCredential.createGSSAPICredential((String)userNameAndPassword[0]));
                    continue;
                }
                if ("MONGODB-CR".equals(authMechanism)) {
                    credentials.add(MongoCredential.createMongoCRCredential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
                    continue;
                }
                if ("MONGODB-X509".equals(authMechanism)) {
                    credentials.add(MongoCredential.createMongoX509Credential((String)userNameAndPassword[0]));
                    continue;
                }
                if ("PLAIN".equals(authMechanism)) {
                    credentials.add(MongoCredential.createPlainCredential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
                    continue;
                }
                if ("SCRAM-SHA-1".equals(authMechanism)) {
                    credentials.add(MongoCredential.createScramSha1Credential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Cannot create MongoCredentials for unknown auth mechanism '%s'!", authMechanism));
            }
            credentials.add(MongoCredential.createCredential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
        }
        this.setValue(credentials);
    }

    private static String[] extractUserNameAndPassword(String text) {
        int dbSeperationIndex = text.lastIndexOf(DATABASE_DELIMINATOR);
        String userNameAndPassword = text.substring(0, dbSeperationIndex);
        return userNameAndPassword.split(USERNAME_PASSWORD_DELIMINATOR);
    }

    private static String extractDB(String text) {
        int dbSeperationIndex = text.lastIndexOf(DATABASE_DELIMINATOR);
        String tmp = text.substring(dbSeperationIndex + 1);
        int optionsSeperationIndex = tmp.lastIndexOf(OPTIONS_DELIMINATOR);
        return optionsSeperationIndex > -1 ? tmp.substring(0, optionsSeperationIndex) : tmp;
    }

    private static Properties extractOptions(String text) {
        int optionsSeperationIndex = text.lastIndexOf(OPTIONS_DELIMINATOR);
        int dbSeperationIndex = text.lastIndexOf(OPTIONS_DELIMINATOR);
        if (optionsSeperationIndex == -1 || dbSeperationIndex > optionsSeperationIndex) {
            return new Properties();
        }
        Properties properties = new Properties();
        for (String option : text.substring(optionsSeperationIndex + 1).split(OPTION_VALUE_DELIMINATOR)) {
            String[] optionArgs = option.split("=");
            properties.put(optionArgs[0], optionArgs[1]);
        }
        return properties;
    }
}

