/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

public class AggregationOptions {
    private static final String CURSOR = "cursor";
    private static final String EXPLAIN = "explain";
    private static final String ALLOW_DISK_USE = "allowDiskUse";
    private final boolean allowDiskUse;
    private final boolean explain;
    private final DBObject cursor;

    public AggregationOptions(boolean allowDiskUse, boolean explain, DBObject cursor) {
        this.allowDiskUse = allowDiskUse;
        this.explain = explain;
        this.cursor = cursor;
    }

    public boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public DBObject getCursor() {
        return this.cursor;
    }

    DBObject applyAndReturnPotentiallyChangedCommand(DBObject command) {
        BasicDBObject result = new BasicDBObject(command.toMap());
        if (this.allowDiskUse && !result.containsField(ALLOW_DISK_USE)) {
            result.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        }
        if (this.explain && !result.containsField(EXPLAIN)) {
            result.put(EXPLAIN, (Object)this.explain);
        }
        if (this.cursor != null && !result.containsField(CURSOR)) {
            result.put(CURSOR, (Object)this.cursor);
        }
        return result;
    }

    public DBObject toDbObject() {
        BasicDBObject dbo = new BasicDBObject();
        dbo.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        dbo.put(EXPLAIN, (Object)this.explain);
        dbo.put(CURSOR, (Object)this.cursor);
        return dbo;
    }

    public String toString() {
        return this.toDbObject().toString();
    }

    public static class Builder {
        private boolean allowDiskUse;
        private boolean explain;
        private DBObject cursor;

        public Builder allowDiskUse(boolean allowDiskUse) {
            this.allowDiskUse = allowDiskUse;
            return this;
        }

        public Builder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public Builder cursor(DBObject cursor) {
            this.cursor = cursor;
            return this;
        }

        public AggregationOptions build() {
            return new AggregationOptions(this.allowDiskUse, this.explain, this.cursor);
        }
    }
}

