/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.LazyLoadingException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.ReflectiveDBRefResolver;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DefaultDbRefResolver
implements DbRefResolver {
    private final MongoDbFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final ObjenesisStd objenesis;

    public DefaultDbRefResolver(MongoDbFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory translator must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
        this.objenesis = new ObjenesisStd(true);
    }

    @Override
    public Object resolveDbRef(MongoPersistentProperty property, com.mongodb.DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        Assert.notNull((Object)callback, (String)"Callback must not be null!");
        if (this.isLazyDbRef(property)) {
            return this.createLazyLoadingProxy(property, dbref, callback, handler);
        }
        return callback.resolve(property);
    }

    @Override
    public com.mongodb.DBRef createDbRef(DBRef annotation, MongoPersistentEntity<?> entity, Object id) {
        return new com.mongodb.DBRef(entity.getCollection(), id);
    }

    @Override
    public DBObject fetch(com.mongodb.DBRef dbRef) {
        return ReflectiveDBRefResolver.fetch(this.mongoDbFactory.getDb(), dbRef);
    }

    private Object createLazyLoadingProxy(MongoPersistentProperty property, com.mongodb.DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Class propertyType = property.getType();
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, dbref, this.exceptionTranslator, callback);
        if (!propertyType.isInterface()) {
            Factory factory = (Factory)this.objenesis.newInstance(this.getEnhancedTypeFor(propertyType));
            factory.setCallbacks(new Callback[]{interceptor});
            return handler.populateId(property, dbref, factory);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        proxyFactory.addInterface(LazyLoadingProxy.class);
        proxyFactory.addInterface(propertyType);
        proxyFactory.addAdvice((Advice)interceptor);
        return handler.populateId(property, dbref, proxyFactory.getProxy());
    }

    private Class<?> getEnhancedTypeFor(Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setInterfaces(new Class[]{LazyLoadingProxy.class});
        return enhancer.createClass();
    }

    private boolean isLazyDbRef(MongoPersistentProperty property) {
        return property.getDBRef() != null && property.getDBRef().lazy();
    }

    static class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        private static final Method INITIALIZE_METHOD;
        private static final Method TO_DBREF_METHOD;
        private static final Method FINALIZE_METHOD;
        private final DbRefResolverCallback callback;
        private final MongoPersistentProperty property;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private volatile boolean resolved;
        private Object result;
        private com.mongodb.DBRef dbref;

        public LazyLoadingInterceptor(MongoPersistentProperty property, com.mongodb.DBRef dbref, PersistenceExceptionTranslator exceptionTranslator, DbRefResolverCallback callback) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            Assert.notNull((Object)exceptionTranslator, (String)"Exception translator must not be null!");
            Assert.notNull((Object)callback, (String)"Callback must not be null!");
            this.dbref = dbref;
            this.callback = callback;
            this.exceptionTranslator = exceptionTranslator;
            this.property = property;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object target;
            if (INITIALIZE_METHOD.equals(method)) {
                return this.ensureResolved();
            }
            if (TO_DBREF_METHOD.equals(method)) {
                return this.dbref;
            }
            if (ReflectionUtils.isObjectMethod((Method)method) && Object.class.equals(method.getDeclaringClass())) {
                if (ReflectionUtils.isToStringMethod((Method)method)) {
                    return this.proxyToString(proxy);
                }
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    return this.proxyEquals(proxy, args[0]);
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    return this.proxyHashCode(proxy);
                }
                if (FINALIZE_METHOD.equals(method)) {
                    return null;
                }
            }
            if ((target = this.ensureResolved()) == null) {
                return null;
            }
            return method.invoke(target, args);
        }

        private String proxyToString(Object proxy) {
            StringBuilder description = new StringBuilder();
            if (this.dbref != null) {
                description.append(this.dbref.getCollectionName());
                description.append(":");
                description.append(this.dbref.getId());
            } else {
                description.append(System.identityHashCode(proxy));
            }
            description.append("$").append(LazyLoadingProxy.class.getSimpleName());
            return description.toString();
        }

        private int proxyHashCode(Object proxy) {
            return this.proxyToString(proxy).hashCode();
        }

        private boolean proxyEquals(Object proxy, Object that) {
            if (!(that instanceof LazyLoadingProxy)) {
                return false;
            }
            if (that == proxy) {
                return true;
            }
            return this.proxyToString(proxy).equals(that.toString());
        }

        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.ensureResolved();
            out.writeObject(this.result);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            try {
                this.resolved = true;
                this.result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new LazyLoadingException("Could not deserialize result", e);
            }
        }

        private synchronized Object resolve() {
            if (!this.resolved) {
                try {
                    return this.callback.resolve(this.property);
                }
                catch (RuntimeException ex) {
                    DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(ex);
                    throw new LazyLoadingException("Unable to lazily resolve DBRef!", (Throwable)translatedException);
                }
            }
            return this.result;
        }

        static {
            try {
                INITIALIZE_METHOD = LazyLoadingProxy.class.getMethod("getTarget", new Class[0]);
                TO_DBREF_METHOD = LazyLoadingProxy.class.getMethod("toDBRef", new Class[0]);
                FINALIZE_METHOD = Object.class.getDeclaredMethod("finalize", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

