/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ReflectiveDBRefResolver {
    private static final Method FETCH_METHOD = ReflectionUtils.findMethod(DBRef.class, (String)"fetch");

    ReflectiveDBRefResolver() {
    }

    public static DBObject fetch(DB db, DBRef ref) {
        Assert.notNull((Object)ref, (String)"DBRef to fetch must not be null!");
        if (MongoClientVersion.isMongo3Driver()) {
            return db.getCollection(ref.getCollectionName()).findOne(ref.getId());
        }
        return (DBObject)ReflectionUtils.invokeMethod((Method)FETCH_METHOD, (Object)ref);
    }
}

