/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

class DBObjectAccessor {
    private final BasicDBObject dbObject;

    public DBObjectAccessor(DBObject dbObject) {
        Assert.notNull((Object)dbObject, (String)"DBObject must not be null!");
        Assert.isInstanceOf(BasicDBObject.class, (Object)dbObject, (String)"Given DBObject must be a BasicDBObject!");
        this.dbObject = (BasicDBObject)dbObject;
    }

    public void put(MongoPersistentProperty prop, Object value) {
        Assert.notNull((Object)prop, (String)"MongoPersistentProperty must not be null!");
        String fieldName = prop.getFieldName();
        if (!fieldName.contains(".")) {
            this.dbObject.put(fieldName, value);
            return;
        }
        Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
        BasicDBObject dbObject = this.dbObject;
        while (parts.hasNext()) {
            String part = parts.next();
            if (parts.hasNext()) {
                BasicDBObject nestedDbObject = new BasicDBObject();
                dbObject.put(part, (Object)nestedDbObject);
                dbObject = nestedDbObject;
                continue;
            }
            dbObject.put(part, value);
        }
    }

    public Object get(MongoPersistentProperty property) {
        String fieldName = property.getFieldName();
        if (!fieldName.contains(".")) {
            return this.dbObject.get(fieldName);
        }
        Iterator<String> parts = Arrays.asList(fieldName.split("\\.")).iterator();
        Object source = this.dbObject;
        Object result = null;
        while (source != null && parts.hasNext()) {
            result = source.get(parts.next());
            if (!parts.hasNext()) continue;
            source = this.getAsMap(result);
        }
        return result;
    }

    private Map<String, Object> getAsMap(Object source) {
        if (source instanceof BasicDBObject) {
            return (BasicDBObject)source;
        }
        if (source instanceof Map) {
            return (Map)source;
        }
        return null;
    }
}

