/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import org.bson.types.Code;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.util.StringUtils;

abstract class MongoConverters {
    private MongoConverters() {
    }

    public static enum NamedMongoScriptToDBObjectConverter implements Converter<NamedMongoScript, DBObject>
    {
        INSTANCE;


        public DBObject convert(NamedMongoScript source) {
            if (source == null) {
                return new BasicDBObject();
            }
            BasicDBObjectBuilder builder = new BasicDBObjectBuilder();
            builder.append("_id", (Object)source.getName());
            builder.append("value", (Object)new Code(source.getCode()));
            return builder.get();
        }
    }

    public static enum DBObjectToNamedMongoScriptCoverter implements Converter<DBObject, NamedMongoScript>
    {
        INSTANCE;


        public NamedMongoScript convert(DBObject source) {
            if (source == null) {
                return null;
            }
            String id = source.get("_id").toString();
            Object rawValue = source.get("value");
            return new NamedMongoScript(id, ((Code)rawValue).getCode());
        }
    }

    @WritingConverter
    public static enum TermToStringConverter implements Converter<Term, String>
    {
        INSTANCE;


        public String convert(Term source) {
            return source == null ? null : source.getFormatted();
        }
    }

    @ReadingConverter
    public static enum DBObjectToStringConverter implements Converter<DBObject, String>
    {
        INSTANCE;


        public String convert(DBObject source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum StringToURLConverter implements Converter<String, URL>
    {
        INSTANCE;

        private static final TypeDescriptor SOURCE;
        private static final TypeDescriptor TARGET;

        public URL convert(String source) {
            try {
                return source == null ? null : new URL(source);
            }
            catch (MalformedURLException e) {
                throw new ConversionFailedException(SOURCE, TARGET, (Object)source, (Throwable)e);
            }
        }

        static {
            SOURCE = TypeDescriptor.valueOf(String.class);
            TARGET = TypeDescriptor.valueOf(URL.class);
        }
    }

    public static enum URLToStringConverter implements Converter<URL, String>
    {
        INSTANCE;


        public String convert(URL source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return StringUtils.hasText((String)source) ? new BigInteger(source) : null;
        }
    }

    public static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    public static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source == null ? null : source.toString();
        }
    }

    public static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(BigInteger source) {
            return source == null ? null : new ObjectId(source.toString(16));
        }
    }

    public static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(ObjectId source) {
            return source == null ? null : new BigInteger(source.toString(), 16);
        }
    }

    public static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(String source) {
            return StringUtils.hasText((String)source) ? new ObjectId(source) : null;
        }
    }

    public static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        public String convert(ObjectId id) {
            return id == null ? null : id.toString();
        }
    }
}

