/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexType;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class MongoQueryCreator
extends AbstractQueryCreator<Query, Criteria> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoQueryCreator.class);
    private static final Pattern PUNCTATION_PATTERN = Pattern.compile("\\p{Punct}");
    private final MongoParameterAccessor accessor;
    private final boolean isGeoNearQuery;
    private final MappingContext<?, MongoPersistentProperty> context;

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context) {
        this(tree, accessor, context, false);
    }

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context, boolean isGeoNearQuery) {
        super(tree, (ParameterAccessor)accessor);
        Assert.notNull(context);
        this.accessor = accessor;
        this.isGeoNearQuery = isGeoNearQuery;
        this.context = context;
    }

    protected Criteria create(Part part, Iterator<Object> iterator) {
        if (this.isGeoNearQuery && part.getType().equals((Object)Part.Type.NEAR)) {
            return null;
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        MongoPersistentProperty property = (MongoPersistentProperty)path.getLeafProperty();
        Criteria criteria = this.from(part, property, Criteria.where(path.toDotPath()), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        return criteria;
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        MongoPersistentProperty property = (MongoPersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(path.toDotPath()), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        Criteria result = new Criteria();
        return result.orOperator(base, criteria);
    }

    protected Query complete(Criteria criteria, Sort sort) {
        Query query = (criteria == null ? new Query() : new Query(criteria)).with(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query " + query);
        }
        return query;
    }

    private Criteria from(Part part, MongoPersistentProperty property, Criteria criteria, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return criteria.gt(parameters.nextConverted(property));
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.nextConverted(property));
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lt(parameters.nextConverted(property));
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.nextConverted(property));
            }
            case BETWEEN: {
                return criteria.gt(parameters.nextConverted(property)).lt(parameters.nextConverted(property));
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case NOT_IN: {
                return criteria.nin(this.nextAsArray(parameters, property));
            }
            case IN: {
                return criteria.in(this.nextAsArray(parameters, property));
            }
            case LIKE: 
            case STARTING_WITH: 
            case ENDING_WITH: 
            case CONTAINING: {
                return this.createContainingCriteria(part, property, criteria, parameters);
            }
            case NOT_CONTAINING: {
                return this.createContainingCriteria(part, property, criteria, parameters).not();
            }
            case REGEX: {
                return criteria.regex(parameters.next().toString());
            }
            case EXISTS: {
                return criteria.exists((Boolean)parameters.next());
            }
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case NEAR: {
                Range<Distance> range = this.accessor.getDistanceRange();
                Distance distance = (Distance)range.getUpperBound();
                Distance minDistance = (Distance)range.getLowerBound();
                Point point = this.accessor.getGeoNearLocation();
                point = point == null ? this.nextAs(parameters, Point.class) : point;
                boolean isSpherical = this.isSpherical(property);
                if (distance == null) {
                    return isSpherical ? criteria.nearSphere(point) : criteria.near(point);
                }
                if (isSpherical || !Metrics.NEUTRAL.equals((Object)distance.getMetric())) {
                    criteria.nearSphere(point);
                } else {
                    criteria.near(point);
                }
                criteria.maxDistance(distance.getNormalizedValue());
                if (minDistance != null) {
                    criteria.minDistance(minDistance.getNormalizedValue());
                }
                return criteria;
            }
            case WITHIN: {
                Object parameter = parameters.next();
                return criteria.within((Shape)parameter);
            }
            case SIMPLE_PROPERTY: {
                return this.isSimpleComparisionPossible(part) ? criteria.is(parameters.nextConverted(property)) : this.createLikeRegexCriteriaOrThrow(part, property, criteria, parameters, false);
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return this.isSimpleComparisionPossible(part) ? criteria.ne(parameters.nextConverted(property)) : this.createLikeRegexCriteriaOrThrow(part, property, criteria, parameters, true);
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private boolean isSimpleComparisionPossible(Part part) {
        switch (part.shouldIgnoreCase()) {
            case NEVER: {
                return true;
            }
            case WHEN_POSSIBLE: {
                return part.getProperty().getType() != String.class;
            }
            case ALWAYS: {
                return false;
            }
        }
        return true;
    }

    private Criteria createLikeRegexCriteriaOrThrow(Part part, MongoPersistentProperty property, Criteria criteria, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters, boolean shouldNegateExpression) {
        PropertyPath path = part.getProperty().getLeafProperty();
        switch (part.shouldIgnoreCase()) {
            case ALWAYS: {
                if (path.getType() != String.class) {
                    throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", path, path.getType()));
                }
            }
            case WHEN_POSSIBLE: {
                if (shouldNegateExpression) {
                    criteria = criteria.not();
                }
                return this.addAppropriateLikeRegexTo(criteria, part, parameters.nextConverted(property).toString());
            }
        }
        throw new IllegalArgumentException(String.format("part.shouldCaseIgnore must be one of %s, but was %s", Arrays.asList(Part.IgnoreCaseType.ALWAYS, Part.IgnoreCaseType.WHEN_POSSIBLE), part.shouldIgnoreCase()));
    }

    private Criteria createContainingCriteria(Part part, MongoPersistentProperty property, Criteria criteria, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        if (property.isCollectionLike()) {
            return criteria.in(this.nextAsArray(parameters, property));
        }
        return this.addAppropriateLikeRegexTo(criteria, part, parameters.next().toString());
    }

    private Criteria addAppropriateLikeRegexTo(Criteria criteria, Part part, String value) {
        return criteria.regex(this.toLikeRegex(value, part), this.toRegexOptions(part));
    }

    private String toRegexOptions(Part part) {
        String regexOptions = null;
        switch (part.shouldIgnoreCase()) {
            case WHEN_POSSIBLE: 
            case ALWAYS: {
                regexOptions = "i";
            }
        }
        return regexOptions;
    }

    private <T> T nextAs(Iterator<Object> iterator, Class<T> type) {
        Object parameter = iterator.next();
        if (parameter.getClass().isAssignableFrom(type)) {
            return (T)parameter;
        }
        throw new IllegalArgumentException(String.format("Expected parameter type of %s but got %s!", type, parameter.getClass()));
    }

    private Object[] nextAsArray(ConvertingParameterAccessor.PotentiallyConvertingIterator iterator, MongoPersistentProperty property) {
        Object next = iterator.nextConverted(property);
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    private String toLikeRegex(String source, Part part) {
        Part.Type type = part.getType();
        String regex = this.prepareAndEscapeStringBeforeApplyingLikeRegex(source, part);
        switch (type) {
            case STARTING_WITH: {
                regex = "^" + regex;
                break;
            }
            case ENDING_WITH: {
                regex = regex + "$";
                break;
            }
            case CONTAINING: 
            case NOT_CONTAINING: {
                regex = ".*" + regex + ".*";
                break;
            }
            case SIMPLE_PROPERTY: 
            case NEGATING_SIMPLE_PROPERTY: {
                regex = "^" + regex + "$";
            }
        }
        return regex;
    }

    private String prepareAndEscapeStringBeforeApplyingLikeRegex(String source, Part qpart) {
        boolean trailingWildcard;
        if (!ObjectUtils.nullSafeEquals((Object)Part.Type.LIKE, (Object)qpart.getType())) {
            return PUNCTATION_PATTERN.matcher(source).find() ? Pattern.quote(source) : source;
        }
        if (source.equals("*")) {
            return ".*";
        }
        StringBuilder sb = new StringBuilder();
        boolean leadingWildcard = source.startsWith("*");
        String valueToUse = source.substring(leadingWildcard ? 1 : 0, (trailingWildcard = source.endsWith("*")) ? source.length() - 1 : source.length());
        if (PUNCTATION_PATTERN.matcher(valueToUse).find()) {
            valueToUse = Pattern.quote(valueToUse);
        }
        if (leadingWildcard) {
            sb.append(".*");
        }
        sb.append(valueToUse);
        if (trailingWildcard) {
            sb.append(".*");
        }
        return sb.toString();
    }

    private boolean isSpherical(MongoPersistentProperty property) {
        GeoSpatialIndexed index = (GeoSpatialIndexed)property.findAnnotation(GeoSpatialIndexed.class);
        return index != null && index.type().equals((Object)GeoSpatialIndexType.GEO_2DSPHERE);
    }
}

