/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.lang.reflect.Method;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.CannotGetMongoDbConnectionException;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.ReflectionUtils;

final class ReflectiveDbInvoker {
    private static final Method DB_IS_AUTHENTICATED_METHOD = ReflectionUtils.findMethod(DB.class, (String)"isAuthenticated");
    private static final Method DB_AUTHENTICATE_METHOD = ReflectionUtils.findMethod(DB.class, (String)"authenticate", (Class[])new Class[]{String.class, char[].class});
    private static final Method DB_REQUEST_DONE_METHOD = ReflectionUtils.findMethod(DB.class, (String)"requestDone");
    private static final Method DB_ADD_USER_METHOD = ReflectionUtils.findMethod(DB.class, (String)"addUser", (Class[])new Class[]{String.class, char[].class});
    private static final Method DB_REQUEST_START_METHOD = ReflectionUtils.findMethod(DB.class, (String)"requestStart");

    private ReflectiveDbInvoker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void authenticate(Mongo mongo, DB db, UserCredentials credentials, String authenticationDatabaseName) {
        DB authDb;
        String databaseName = db.getName();
        DB dB = authDb = databaseName.equals(authenticationDatabaseName) ? db : mongo.getDB(authenticationDatabaseName);
        synchronized (dB) {
            Boolean isAuthenticated = (Boolean)ReflectionUtils.invokeMethod((Method)DB_IS_AUTHENTICATED_METHOD, (Object)authDb);
            if (!isAuthenticated.booleanValue()) {
                String username = credentials.getUsername();
                String password = credentials.hasPassword() ? credentials.getPassword() : null;
                Boolean authenticated = (Boolean)ReflectionUtils.invokeMethod((Method)DB_AUTHENTICATE_METHOD, (Object)authDb, (Object[])new Object[]{username, password == null ? null : password.toCharArray()});
                if (!authenticated.booleanValue()) {
                    throw new CannotGetMongoDbConnectionException("Failed to authenticate to database [" + databaseName + "], " + credentials.toString(), databaseName, credentials);
                }
            }
        }
    }

    public static void requestStart(DB db) {
        if (MongoClientVersion.isMongo3Driver()) {
            return;
        }
        ReflectionUtils.invokeMethod((Method)DB_REQUEST_START_METHOD, (Object)db);
    }

    public static void requestDone(DB db) {
        if (MongoClientVersion.isMongo3Driver()) {
            return;
        }
        ReflectionUtils.invokeMethod((Method)DB_REQUEST_DONE_METHOD, (Object)db);
    }

    public static void addUser(DB db, String username, char[] password) {
        if (MongoClientVersion.isMongo3Driver()) {
            throw new UnsupportedOperationException("Please use DB.command(\u2026) to call either the createUser or updateUser command!");
        }
        ReflectionUtils.invokeMethod((Method)DB_ADD_USER_METHOD, (Object)db, (Object[])new Object[]{username, password});
    }
}

