/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonGeometryCollection;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class GeoConverters {
    private GeoConverters() {
    }

    public static Collection<? extends Object> getConvertersToRegister() {
        return Arrays.asList(new Enum[]{BoxToDbObjectConverter.INSTANCE, PolygonToDbObjectConverter.INSTANCE, CircleToDbObjectConverter.INSTANCE, SphereToDbObjectConverter.INSTANCE, DbObjectToBoxConverter.INSTANCE, DbObjectToPolygonConverter.INSTANCE, DbObjectToCircleConverter.INSTANCE, DbObjectToSphereConverter.INSTANCE, DbObjectToPointConverter.INSTANCE, PointToDbObjectConverter.INSTANCE, GeoCommandToDbObjectConverter.INSTANCE, GeoJsonToDbObjectConverter.INSTANCE, GeoJsonPointToDbObjectConverter.INSTANCE, GeoJsonPolygonToDbObjectConverter.INSTANCE, DbObjectToGeoJsonPointConverter.INSTANCE, DbObjectToGeoJsonPolygonConverter.INSTANCE, DbObjectToGeoJsonLineStringConverter.INSTANCE, DbObjectToGeoJsonMultiLineStringConverter.INSTANCE, DbObjectToGeoJsonMultiPointConverter.INSTANCE, DbObjectToGeoJsonMultiPolygonConverter.INSTANCE, DbObjectToGeoJsonGeometryCollectionConverter.INSTANCE});
    }

    static List<Double> toList(Point point) {
        return Arrays.asList(point.getX(), point.getY());
    }

    static List<Point> toListOfPoint(BasicDBList listOfCoordinatePairs) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Object point : listOfCoordinatePairs) {
            Assert.isInstanceOf(List.class, point);
            List coordinatesList = (List)point;
            points.add(new GeoJsonPoint((Double)coordinatesList.get(0), (Double)coordinatesList.get(1)));
        }
        return points;
    }

    static GeoJsonPolygon toGeoJsonPolygon(BasicDBList dbList) {
        return new GeoJsonPolygon(GeoConverters.toListOfPoint((BasicDBList)dbList.get(0)));
    }

    static enum DbObjectToGeoJsonGeometryCollectionConverter implements Converter<DBObject, GeoJsonGeometryCollection>
    {
        INSTANCE;


        public GeoJsonGeometryCollection convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"GeometryCollection"), (String)String.format("Cannot convert type '%s' to GeometryCollection.", source.get("type")));
            ArrayList geometries = new ArrayList();
            for (Object o : (List)source.get("geometries")) {
                geometries.add(DbObjectToGeoJsonGeometryCollectionConverter.convertGeometries((DBObject)o));
            }
            return new GeoJsonGeometryCollection(geometries);
        }

        private static GeoJson<?> convertGeometries(DBObject source) {
            Object type = source.get("type");
            if (ObjectUtils.nullSafeEquals((Object)type, (Object)"Point")) {
                return DbObjectToGeoJsonPointConverter.INSTANCE.convert(source);
            }
            if (ObjectUtils.nullSafeEquals((Object)type, (Object)"MultiPoint")) {
                return DbObjectToGeoJsonMultiPointConverter.INSTANCE.convert(source);
            }
            if (ObjectUtils.nullSafeEquals((Object)type, (Object)"LineString")) {
                return DbObjectToGeoJsonLineStringConverter.INSTANCE.convert(source);
            }
            if (ObjectUtils.nullSafeEquals((Object)type, (Object)"MultiLineString")) {
                return DbObjectToGeoJsonMultiLineStringConverter.INSTANCE.convert(source);
            }
            if (ObjectUtils.nullSafeEquals((Object)type, (Object)"Polygon")) {
                return DbObjectToGeoJsonPolygonConverter.INSTANCE.convert(source);
            }
            if (ObjectUtils.nullSafeEquals((Object)type, (Object)"MultiPolygon")) {
                return DbObjectToGeoJsonMultiPolygonConverter.INSTANCE.convert(source);
            }
            throw new IllegalArgumentException(String.format("Cannot convert unknown GeoJson type %s", type));
        }
    }

    static enum DbObjectToGeoJsonMultiLineStringConverter implements Converter<DBObject, GeoJsonMultiLineString>
    {
        INSTANCE;


        public GeoJsonMultiLineString convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"MultiLineString"), (String)String.format("Cannot convert type '%s' to MultiLineString.", source.get("type")));
            ArrayList<GeoJsonLineString> lines = new ArrayList<GeoJsonLineString>();
            BasicDBList cords = (BasicDBList)source.get("coordinates");
            for (Object line : cords) {
                lines.add(new GeoJsonLineString(GeoConverters.toListOfPoint((BasicDBList)line)));
            }
            return new GeoJsonMultiLineString((List<GeoJsonLineString>)lines);
        }
    }

    static enum DbObjectToGeoJsonMultiPointConverter implements Converter<DBObject, GeoJsonMultiPoint>
    {
        INSTANCE;


        public GeoJsonMultiPoint convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"MultiPoint"), (String)String.format("Cannot convert type '%s' to MultiPoint.", source.get("type")));
            BasicDBList cords = (BasicDBList)source.get("coordinates");
            return new GeoJsonMultiPoint(GeoConverters.toListOfPoint(cords));
        }
    }

    static enum DbObjectToGeoJsonLineStringConverter implements Converter<DBObject, GeoJsonLineString>
    {
        INSTANCE;


        public GeoJsonLineString convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"LineString"), (String)String.format("Cannot convert type '%s' to LineString.", source.get("type")));
            BasicDBList cords = (BasicDBList)source.get("coordinates");
            return new GeoJsonLineString(GeoConverters.toListOfPoint(cords));
        }
    }

    static enum DbObjectToGeoJsonMultiPolygonConverter implements Converter<DBObject, GeoJsonMultiPolygon>
    {
        INSTANCE;


        public GeoJsonMultiPolygon convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"MultiPolygon"), (String)String.format("Cannot convert type '%s' to MultiPolygon.", source.get("type")));
            BasicDBList dbl = (BasicDBList)source.get("coordinates");
            ArrayList<GeoJsonPolygon> polygones = new ArrayList<GeoJsonPolygon>();
            for (Object polygon : dbl) {
                polygones.add(GeoConverters.toGeoJsonPolygon((BasicDBList)polygon));
            }
            return new GeoJsonMultiPolygon(polygones);
        }
    }

    static enum DbObjectToGeoJsonPolygonConverter implements Converter<DBObject, GeoJsonPolygon>
    {
        INSTANCE;


        public GeoJsonPolygon convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"Polygon"), (String)String.format("Cannot convert type '%s' to Polygon.", source.get("type")));
            return GeoConverters.toGeoJsonPolygon((BasicDBList)source.get("coordinates"));
        }
    }

    static enum DbObjectToGeoJsonPointConverter implements Converter<DBObject, GeoJsonPoint>
    {
        INSTANCE;


        public GeoJsonPoint convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)source.get("type"), (Object)"Point"), (String)String.format("Cannot convert type '%s' to Point.", source.get("type")));
            List dbl = (List)source.get("coordinates");
            return new GeoJsonPoint((Double)dbl.get(0), (Double)dbl.get(1));
        }
    }

    static enum GeoJsonPolygonToDbObjectConverter implements Converter<GeoJsonPolygon, DBObject>
    {
        INSTANCE;


        public DBObject convert(GeoJsonPolygon source) {
            return GeoJsonToDbObjectConverter.INSTANCE.convert(source);
        }
    }

    static enum GeoJsonPointToDbObjectConverter implements Converter<GeoJsonPoint, DBObject>
    {
        INSTANCE;


        public DBObject convert(GeoJsonPoint source) {
            return GeoJsonToDbObjectConverter.INSTANCE.convert(source);
        }
    }

    static enum GeoJsonToDbObjectConverter implements Converter<GeoJson, DBObject>
    {
        INSTANCE;


        public DBObject convert(GeoJson source) {
            if (source == null) {
                return null;
            }
            BasicDBObject dbo = new BasicDBObject("type", (Object)source.getType());
            if (source instanceof GeoJsonGeometryCollection) {
                BasicDBList dbl = new BasicDBList();
                for (GeoJson<?> geometry : ((GeoJsonGeometryCollection)source).getCoordinates()) {
                    dbl.add((Object)this.convert(geometry));
                }
                dbo.put("geometries", (Object)dbl);
            } else {
                dbo.put("coordinates", this.convertIfNecessarry(source.getCoordinates()));
            }
            return dbo;
        }

        private Object convertIfNecessarry(Object candidate) {
            if (candidate instanceof GeoJson) {
                return this.convertIfNecessarry(((GeoJson)candidate).getCoordinates());
            }
            if (candidate instanceof Iterable) {
                BasicDBList dbl = new BasicDBList();
                for (Object element : (Iterable)candidate) {
                    dbl.add(this.convertIfNecessarry(element));
                }
                return dbl;
            }
            if (candidate instanceof Point) {
                return GeoConverters.toList((Point)candidate);
            }
            return candidate;
        }
    }

    static enum GeoCommandToDbObjectConverter implements Converter<GeoCommand, DBObject>
    {
        INSTANCE;


        public DBObject convert(GeoCommand source) {
            if (source == null) {
                return null;
            }
            BasicDBList argument = new BasicDBList();
            Shape shape = source.getShape();
            if (shape instanceof GeoJson) {
                return GeoJsonToDbObjectConverter.INSTANCE.convert((GeoJson)shape);
            }
            if (shape instanceof Box) {
                argument.add(GeoConverters.toList(((Box)shape).getFirst()));
                argument.add(GeoConverters.toList(((Box)shape).getSecond()));
            } else if (shape instanceof Circle) {
                argument.add(GeoConverters.toList(((Circle)shape).getCenter()));
                argument.add((Object)((Circle)shape).getRadius().getNormalizedValue());
            } else if (shape instanceof Circle) {
                argument.add(GeoConverters.toList(((Circle)shape).getCenter()));
                argument.add((Object)((Circle)shape).getRadius());
            } else if (shape instanceof Polygon) {
                for (Point point : ((Polygon)shape).getPoints()) {
                    argument.add(GeoConverters.toList(point));
                }
            } else if (shape instanceof Sphere) {
                argument.add(GeoConverters.toList(((Sphere)shape).getCenter()));
                argument.add((Object)((Sphere)shape).getRadius().getNormalizedValue());
            }
            return new BasicDBObject(source.getCommand(), (Object)argument);
        }
    }

    @ReadingConverter
    static enum DbObjectToPolygonConverter implements Converter<DBObject, Polygon>
    {
        INSTANCE;


        public Polygon convert(DBObject source) {
            if (source == null) {
                return null;
            }
            List points = (List)source.get("points");
            ArrayList<Point> newPoints = new ArrayList<Point>(points.size());
            for (DBObject element : points) {
                Assert.notNull((Object)element, (String)"Point elements of polygon must not be null!");
                newPoints.add(DbObjectToPointConverter.INSTANCE.convert(element));
            }
            return new Polygon(newPoints);
        }
    }

    static enum PolygonToDbObjectConverter implements Converter<Polygon, DBObject>
    {
        INSTANCE;


        public DBObject convert(Polygon source) {
            if (source == null) {
                return null;
            }
            List points = source.getPoints();
            ArrayList<DBObject> pointTuples = new ArrayList<DBObject>(points.size());
            for (Point point : points) {
                pointTuples.add(PointToDbObjectConverter.INSTANCE.convert(point));
            }
            BasicDBObject result = new BasicDBObject();
            result.put("points", pointTuples);
            return result;
        }
    }

    @ReadingConverter
    static enum DbObjectToSphereConverter implements Converter<DBObject, Sphere>
    {
        INSTANCE;


        public Sphere convert(DBObject source) {
            if (source == null) {
                return null;
            }
            DBObject center = (DBObject)source.get("center");
            Double radius = (Double)source.get("radius");
            Distance distance = new Distance(radius.doubleValue());
            if (source.containsField("metric")) {
                String metricString = (String)source.get("metric");
                Assert.notNull((Object)metricString, (String)"Metric must not be null!");
                distance = distance.in((Metric)Metrics.valueOf((String)metricString));
            }
            Assert.notNull((Object)center, (String)"Center must not be null!");
            Assert.notNull((Object)radius, (String)"Radius must not be null!");
            return new Sphere(DbObjectToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    static enum SphereToDbObjectConverter implements Converter<Sphere, DBObject>
    {
        INSTANCE;


        public DBObject convert(Sphere source) {
            if (source == null) {
                return null;
            }
            BasicDBObject result = new BasicDBObject();
            result.put("center", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    @ReadingConverter
    static enum DbObjectToCircleConverter implements Converter<DBObject, Circle>
    {
        INSTANCE;


        public Circle convert(DBObject source) {
            if (source == null) {
                return null;
            }
            DBObject center = (DBObject)source.get("center");
            Double radius = (Double)source.get("radius");
            Distance distance = new Distance(radius.doubleValue());
            if (source.containsField("metric")) {
                String metricString = (String)source.get("metric");
                Assert.notNull((Object)metricString, (String)"Metric must not be null!");
                distance = distance.in((Metric)Metrics.valueOf((String)metricString));
            }
            Assert.notNull((Object)center, (String)"Center must not be null!");
            Assert.notNull((Object)radius, (String)"Radius must not be null!");
            return new Circle(DbObjectToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    static enum CircleToDbObjectConverter implements Converter<Circle, DBObject>
    {
        INSTANCE;


        public DBObject convert(Circle source) {
            if (source == null) {
                return null;
            }
            BasicDBObject result = new BasicDBObject();
            result.put("center", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    @ReadingConverter
    static enum DbObjectToBoxConverter implements Converter<DBObject, Box>
    {
        INSTANCE;


        public Box convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Point first = DbObjectToPointConverter.INSTANCE.convert((DBObject)source.get("first"));
            Point second = DbObjectToPointConverter.INSTANCE.convert((DBObject)source.get("second"));
            return new Box(first, second);
        }
    }

    @WritingConverter
    static enum BoxToDbObjectConverter implements Converter<Box, DBObject>
    {
        INSTANCE;


        public DBObject convert(Box source) {
            if (source == null) {
                return null;
            }
            BasicDBObject result = new BasicDBObject();
            result.put("first", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getFirst()));
            result.put("second", (Object)PointToDbObjectConverter.INSTANCE.convert(source.getSecond()));
            return result;
        }
    }

    static enum PointToDbObjectConverter implements Converter<Point, DBObject>
    {
        INSTANCE;


        public DBObject convert(Point source) {
            return source == null ? null : new BasicDBObject("x", (Object)source.getX()).append("y", (Object)source.getY());
        }
    }

    @ReadingConverter
    static enum DbObjectToPointConverter implements Converter<DBObject, Point>
    {
        INSTANCE;


        public Point convert(DBObject source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue((source.keySet().size() == 2 ? 1 : 0) != 0, (String)"Source must contain 2 elements");
            return new Point(((Double)source.get("x")).doubleValue(), ((Double)source.get("y")).doubleValue());
        }
    }
}

