/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class SpringDataMongodbSerializer
extends MongodbSerializer {
    private static final String ID_KEY = "_id";
    private static final Set<PathType> PATH_TYPES;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public SpringDataMongodbSerializer(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null!");
        this.mappingContext = converter.getMappingContext();
        this.converter = converter;
        this.mapper = new QueryMapper(converter);
    }

    public Object visit(Constant<?> expr, Void context) {
        if (!ClassUtils.isAssignable(Enum.class, (Class)expr.getType())) {
            return super.visit(expr, context);
        }
        return this.converter.convertToMongoType(expr.getConstant());
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata<?> metadata) {
        if (!metadata.getPathType().equals((Object)PathType.PROPERTY)) {
            return super.getKeyForPath(expr, metadata);
        }
        Path parent = metadata.getParent();
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        MongoPersistentProperty property = (MongoPersistentProperty)entity.getPersistentProperty(metadata.getName());
        return property == null ? super.getKeyForPath(expr, metadata) : property.getFieldName();
    }

    protected DBObject asDBObject(String key, Object value) {
        if (ID_KEY.equals(key)) {
            return this.mapper.getMappedObject(super.asDBObject(key, value), null);
        }
        return super.asDBObject(key, value instanceof Pattern ? value : this.converter.convertToMongoType(value));
    }

    protected boolean isReference(Path<?> path) {
        MongoPersistentProperty property = this.getPropertyFor(path);
        return property == null ? false : property.isAssociation();
    }

    protected DBRef asReference(Object constant) {
        return this.converter.toDBRef(constant, null);
    }

    protected DBRef asReference(Operation<?> expr, int constIndex) {
        for (Object arg : expr.getArgs()) {
            if (!(arg instanceof Path)) continue;
            MongoPersistentProperty property = this.getPropertyFor((Path)arg);
            Object constant = ((Constant)expr.getArg(constIndex)).getConstant();
            return this.converter.toDBRef(constant, property);
        }
        return super.asReference(expr, constIndex);
    }

    private MongoPersistentProperty getPropertyFor(Path<?> path) {
        Path parent = path.getMetadata().getParent();
        if (parent == null || !PATH_TYPES.contains(path.getMetadata().getPathType())) {
            return null;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        return entity != null ? (MongoPersistentProperty)entity.getPersistentProperty(path.getMetadata().getName()) : null;
    }

    static {
        HashSet<PathType> pathTypes = new HashSet<PathType>();
        pathTypes.add(PathType.VARIABLE);
        pathTypes.add(PathType.PROPERTY);
        PATH_TYPES = Collections.unmodifiableSet(pathTypes);
    }
}

