/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;

public class GeoJsonPolygon
extends Polygon
implements GeoJson<List<GeoJsonLineString>> {
    private static final long serialVersionUID = 3936163018187247185L;
    private static final String TYPE = "Polygon";
    private List<GeoJsonLineString> coordinates = new ArrayList<GeoJsonLineString>();

    public GeoJsonPolygon(Point first, Point second, Point third, Point fourth, Point ... others) {
        this(GeoJsonPolygon.asList(first, second, third, fourth, others));
    }

    public GeoJsonPolygon(List<Point> points) {
        super(points);
        this.coordinates.add(new GeoJsonLineString(points));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<GeoJsonLineString> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    private static List<Point> asList(Point first, Point second, Point third, Point fourth, Point ... others) {
        ArrayList<Point> result = new ArrayList<Point>(3 + others.length);
        result.add(first);
        result.add(second);
        result.add(third);
        result.add(fourth);
        result.addAll(Arrays.asList(others));
        return result;
    }
}

