/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.bulk.BulkWriteResult;
import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableInsertOperationSupport
implements ExecutableInsertOperation {
    private final MongoTemplate template;

    ExecutableInsertOperationSupport(MongoTemplate template) {
        Assert.notNull((Object)template, (String)"Template must not be null!");
        this.template = template;
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableInsertSupport<T>(this.template, domainType, null, null);
    }

    static class ExecutableInsertSupport<T>
    implements ExecutableInsertOperation.ExecutableInsert<T> {
        @NonNull
        private final MongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        @Nullable
        private final String collection;
        @Nullable
        private final BulkOperations.BulkMode bulkMode;

        @Override
        public void one(T object) {
            Assert.notNull(object, (String)"Object must not be null!");
            this.template.insert(object, this.getCollectionName());
        }

        @Override
        public void all(Collection<? extends T> objects) {
            Assert.notNull(objects, (String)"Objects must not be null!");
            this.template.insert(objects, this.getCollectionName());
        }

        @Override
        public BulkWriteResult bulk(Collection<? extends T> objects) {
            Assert.notNull(objects, (String)"Objects must not be null!");
            return this.template.bulkOps(this.bulkMode != null ? this.bulkMode : BulkOperations.BulkMode.ORDERED, this.domainType, this.getCollectionName()).insert(new ArrayList<T>(objects)).execute();
        }

        @Override
        public ExecutableInsertOperation.InsertWithBulkMode<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, collection, this.bulkMode);
        }

        @Override
        public ExecutableInsertOperation.TerminatingBulkInsert<T> withBulkMode(BulkOperations.BulkMode bulkMode) {
            Assert.notNull((Object)((Object)bulkMode), (String)"BulkMode must not be null!");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, this.collection, bulkMode);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }

        public ExecutableInsertSupport(@NonNull MongoTemplate template, @NonNull Class<T> domainType, @Nullable String collection, @Nullable BulkOperations.BulkMode bulkMode) {
            if (template == null) {
                throw new IllegalArgumentException("template is marked @NonNull but is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is marked @NonNull but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.collection = collection;
            this.bulkMode = bulkMode;
        }
    }
}

