/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.auditing.config.IsNewAwareAuditingHandlerBeanDefinitionParser;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.AuditingEventListener;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoAuditingBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return AuditingEventListener.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String mappingContextRef = element.getAttribute("mapping-context-ref");
        if (!StringUtils.hasText((String)mappingContextRef)) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            if (!registry.containsBeanDefinition("mongoMappingContext")) {
                registry.registerBeanDefinition("mongoMappingContext", (BeanDefinition)new RootBeanDefinition(MongoMappingContext.class));
            }
            mappingContextRef = "mongoMappingContext";
        }
        IsNewAwareAuditingHandlerBeanDefinitionParser parser = new IsNewAwareAuditingHandlerBeanDefinitionParser(mappingContextRef);
        parser.parse(element, parserContext);
        builder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)parser.getResolvedBeanName(), (Object)parserContext.extractSource((Object)element)));
    }
}

