/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.MongoClient;
import java.net.UnknownHostException;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Server Information")
public class ServerInfo
extends AbstractMonitor {
    public ServerInfo(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedOperation(description="Server host name")
    public String getHostName() throws UnknownHostException {
        return this.getMongoClient().getAddress().getHost();
    }

    @ManagedMetric(displayName="Uptime Estimate")
    public double getUptimeEstimate() {
        return (Double)this.getServerStatus().get((Object)"uptimeEstimate");
    }

    @ManagedOperation(description="MongoDB Server Version")
    public String getVersion() {
        return (String)this.getServerStatus().get((Object)"version");
    }

    @ManagedOperation(description="Local Time")
    public String getLocalTime() {
        return (String)this.getServerStatus().get((Object)"localTime");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Server uptime in seconds", unit="seconds")
    public double getUptime() {
        return (Double)this.getServerStatus().get((Object)"uptime");
    }
}

