/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import lombok.NonNull;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.ReactiveRemoveOperation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveRemoveOperationSupport
implements ReactiveRemoveOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final ReactiveMongoTemplate tempate;

    @Override
    public <T> ReactiveRemoveOperation.ReactiveRemove<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveRemoveSupport<T>(this.tempate, domainType, ALL_QUERY, null);
    }

    public ReactiveRemoveOperationSupport(@NonNull ReactiveMongoTemplate tempate) {
        if (tempate == null) {
            throw new IllegalArgumentException("tempate is marked @NonNull but is null");
        }
        this.tempate = tempate;
    }

    static class ReactiveRemoveSupport<T>
    implements ReactiveRemoveOperation.ReactiveRemove<T>,
    ReactiveRemoveOperation.RemoveWithCollection<T> {
        @NonNull
        private final ReactiveMongoTemplate template;
        @NonNull
        private final Class<T> domainType;
        private final Query query;
        private final String collection;

        @Override
        public ReactiveRemoveOperation.RemoveWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ReactiveRemoveSupport<T>(this.template, this.domainType, this.query, collection);
        }

        @Override
        public ReactiveRemoveOperation.TerminatingRemove<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ReactiveRemoveSupport<T>(this.template, this.domainType, query, this.collection);
        }

        @Override
        public Mono<DeleteResult> all() {
            String collectionName = this.getCollectionName();
            return this.template.doRemove(collectionName, this.query, this.domainType);
        }

        @Override
        public Flux<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.query, this.domainType);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }

        public ReactiveRemoveSupport(@NonNull ReactiveMongoTemplate template, @NonNull Class<T> domainType, Query query, String collection) {
            if (template == null) {
                throw new IllegalArgumentException("template is marked @NonNull but is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is marked @NonNull but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.collection = collection;
        }
    }
}

