/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ClientSessionException;
import org.springframework.data.mongodb.LazyLoadingException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultDbRefResolver
implements DbRefResolver {
    private final MongoDbFactory mongoDbFactory;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final ObjenesisStd objenesis;

    public DefaultDbRefResolver(MongoDbFactory mongoDbFactory) {
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory translator must not be null!");
        this.mongoDbFactory = mongoDbFactory;
        this.exceptionTranslator = mongoDbFactory.getExceptionTranslator();
        this.objenesis = new ObjenesisStd(true);
    }

    @Override
    public Object resolveDbRef(MongoPersistentProperty property, @Nullable DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        Assert.notNull((Object)callback, (String)"Callback must not be null!");
        Assert.notNull((Object)handler, (String)"Handler must not be null!");
        if (this.isLazyDbRef(property)) {
            return this.createLazyLoadingProxy(property, dbref, callback, handler);
        }
        return callback.resolve(property);
    }

    @Override
    public Document fetch(DBRef dbRef) {
        StringUtils.hasText((String)dbRef.getDatabaseName());
        return (Document)this.getCollection(dbRef).find(Filters.eq((String)"_id", (Object)dbRef.getId())).first();
    }

    @Override
    public List<Document> bulkFetch(List<DBRef> refs) {
        Assert.notNull((Object)this.mongoDbFactory, (String)"Factory must not be null!");
        Assert.notNull(refs, (String)"DBRef to fetch must not be null!");
        if (refs.isEmpty()) {
            return Collections.emptyList();
        }
        String collection = refs.iterator().next().getCollectionName();
        ArrayList<Object> ids = new ArrayList<Object>(refs.size());
        for (DBRef ref : refs) {
            if (!collection.equals(ref.getCollectionName())) {
                throw new InvalidDataAccessApiUsageException("DBRefs must all target the same collection for bulk fetch operation.");
            }
            ids.add(ref.getId());
        }
        List result = (List)this.getCollection(refs.iterator().next()).find((Bson)new Document("_id", (Object)new Document("$in", ids))).into(new ArrayList());
        return ids.stream().flatMap(id -> DefaultDbRefResolver.documentWithId(id, result)).collect(Collectors.toList());
    }

    private Object createLazyLoadingProxy(MongoPersistentProperty property, @Nullable DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Class propertyType = property.getType();
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, dbref, this.exceptionTranslator, callback);
        if (!propertyType.isInterface()) {
            Factory factory = (Factory)this.objenesis.newInstance(this.getEnhancedTypeFor(propertyType));
            factory.setCallbacks(new Callback[]{interceptor});
            return handler.populateId(property, dbref, factory);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        proxyFactory.addInterface(LazyLoadingProxy.class);
        proxyFactory.addInterface(propertyType);
        proxyFactory.addAdvice((Advice)interceptor);
        return handler.populateId(property, dbref, proxyFactory.getProxy());
    }

    private Class<?> getEnhancedTypeFor(Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setInterfaces(new Class[]{LazyLoadingProxy.class});
        return enhancer.createClass();
    }

    private boolean isLazyDbRef(MongoPersistentProperty property) {
        return property.getDBRef() != null && property.getDBRef().lazy();
    }

    private static Stream<Document> documentWithId(Object identifier, Collection<Document> documents) {
        return documents.stream().filter(it -> it.get((Object)"_id").equals(identifier)).limit(1L);
    }

    protected MongoCollection<Document> getCollection(DBRef dbref) {
        return (StringUtils.hasText((String)dbref.getDatabaseName()) ? this.mongoDbFactory.getDb(dbref.getDatabaseName()) : this.mongoDbFactory.getDb()).getCollection(dbref.getCollectionName(), Document.class);
    }

    static class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        private static final Method INITIALIZE_METHOD;
        private static final Method TO_DBREF_METHOD;
        private static final Method FINALIZE_METHOD;
        private final DbRefResolverCallback callback;
        private final MongoPersistentProperty property;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private volatile boolean resolved;
        @Nullable
        private final DBRef dbref;
        @Nullable
        private Object result;

        public LazyLoadingInterceptor(MongoPersistentProperty property, @Nullable DBRef dbref, PersistenceExceptionTranslator exceptionTranslator, DbRefResolverCallback callback) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            Assert.notNull((Object)exceptionTranslator, (String)"Exception translator must not be null!");
            Assert.notNull((Object)callback, (String)"Callback must not be null!");
            this.dbref = dbref;
            this.callback = callback;
            this.exceptionTranslator = exceptionTranslator;
            this.property = property;
        }

        public Object invoke(@Nullable MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        @Nullable
        public Object intercept(Object obj, Method method, Object[] args, @Nullable MethodProxy proxy) throws Throwable {
            Object target;
            if (INITIALIZE_METHOD.equals(method)) {
                return this.ensureResolved();
            }
            if (TO_DBREF_METHOD.equals(method)) {
                return this.dbref;
            }
            if (ReflectionUtils.isObjectMethod((Method)method) && Object.class.equals(method.getDeclaringClass())) {
                if (ReflectionUtils.isToStringMethod((Method)method)) {
                    return this.proxyToString(proxy);
                }
                if (ReflectionUtils.isEqualsMethod((Method)method)) {
                    return this.proxyEquals(proxy, args[0]);
                }
                if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                    return this.proxyHashCode(proxy);
                }
                if (FINALIZE_METHOD.equals(method)) {
                    return null;
                }
            }
            if ((target = this.ensureResolved()) == null) {
                return null;
            }
            ReflectionUtils.makeAccessible((Method)method);
            return method.invoke(target, args);
        }

        private String proxyToString(@Nullable Object proxy) {
            StringBuilder description = new StringBuilder();
            if (this.dbref != null) {
                description.append(this.dbref.getCollectionName());
                description.append(":");
                description.append(this.dbref.getId());
            } else {
                description.append(System.identityHashCode(proxy));
            }
            description.append("$").append(LazyLoadingProxy.class.getSimpleName());
            return description.toString();
        }

        private int proxyHashCode(@Nullable Object proxy) {
            return this.proxyToString(proxy).hashCode();
        }

        private boolean proxyEquals(@Nullable Object proxy, Object that) {
            if (!(that instanceof LazyLoadingProxy)) {
                return false;
            }
            if (that == proxy) {
                return true;
            }
            return this.proxyToString(proxy).equals(that.toString());
        }

        @Nullable
        private Object ensureResolved() {
            if (!this.resolved) {
                this.result = this.resolve();
                this.resolved = true;
            }
            return this.result;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.ensureResolved();
            out.writeObject(this.result);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            try {
                this.resolved = true;
                this.result = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new LazyLoadingException("Could not deserialize result", e);
            }
        }

        @Nullable
        private synchronized Object resolve() {
            if (!this.resolved) {
                try {
                    return this.callback.resolve(this.property);
                }
                catch (RuntimeException ex) {
                    DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(ex);
                    if (translatedException instanceof ClientSessionException) {
                        throw new LazyLoadingException("Unable to lazily resolve DBRef! Invalid session state.", ex);
                    }
                    throw new LazyLoadingException("Unable to lazily resolve DBRef!", (Throwable)(translatedException != null ? translatedException : ex));
                }
            }
            return this.result;
        }

        static {
            try {
                INITIALIZE_METHOD = LazyLoadingProxy.class.getMethod("getTarget", new Class[0]);
                TO_DBREF_METHOD = LazyLoadingProxy.class.getMethod("toDBRef", new Class[0]);
                FINALIZE_METHOD = Object.class.getDeclaredMethod("finalize", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

