/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AggregationOptions {
    private static final String BATCH_SIZE = "batchSize";
    private static final String CURSOR = "cursor";
    private static final String EXPLAIN = "explain";
    private static final String ALLOW_DISK_USE = "allowDiskUse";
    private static final String COLLATION = "collation";
    private final boolean allowDiskUse;
    private final boolean explain;
    private final Optional<Document> cursor;
    private final Optional<Collation> collation;

    public AggregationOptions(boolean allowDiskUse, boolean explain, Document cursor) {
        this(allowDiskUse, explain, cursor, null);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation) {
        this.allowDiskUse = allowDiskUse;
        this.explain = explain;
        this.cursor = Optional.ofNullable(cursor);
        this.collation = Optional.ofNullable(collation);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, int cursorBatchSize) {
        this(allowDiskUse, explain, AggregationOptions.createCursor(cursorBatchSize), null);
    }

    public static AggregationOptions fromDocument(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null!");
        boolean allowDiskUse = document.getBoolean((Object)ALLOW_DISK_USE, false);
        boolean explain = document.getBoolean((Object)EXPLAIN, false);
        Document cursor = (Document)document.get((Object)CURSOR, Document.class);
        Collation collation = document.containsKey((Object)COLLATION) ? Collation.from((Document)document.get((Object)COLLATION, Document.class)) : null;
        return new AggregationOptions(allowDiskUse, explain, cursor, collation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public boolean isExplain() {
        return this.explain;
    }

    @Nullable
    public Integer getCursorBatchSize() {
        if (this.cursor.filter(val -> val.containsKey((Object)BATCH_SIZE)).isPresent()) {
            return (Integer)this.cursor.get().get((Object)BATCH_SIZE, Integer.class);
        }
        return null;
    }

    public Optional<Document> getCursor() {
        return this.cursor;
    }

    public Optional<Collation> getCollation() {
        return this.collation;
    }

    Document applyAndReturnPotentiallyChangedCommand(Document command) {
        Document result = new Document((Map)command);
        if (this.allowDiskUse && !result.containsKey((Object)ALLOW_DISK_USE)) {
            result.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        }
        if (this.explain && !result.containsKey((Object)EXPLAIN)) {
            result.put(EXPLAIN, (Object)this.explain);
        }
        if (!result.containsKey((Object)CURSOR)) {
            this.cursor.ifPresent(val -> result.put(CURSOR, val));
        }
        if (!result.containsKey((Object)COLLATION)) {
            this.collation.map(Collation::toDocument).ifPresent(val -> result.append(COLLATION, val));
        }
        return result;
    }

    public Document toDocument() {
        Document document = new Document();
        document.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        document.put(EXPLAIN, (Object)this.explain);
        this.cursor.ifPresent(val -> document.put(CURSOR, val));
        this.collation.ifPresent(val -> document.append(COLLATION, (Object)val.toDocument()));
        return document;
    }

    public String toString() {
        return this.toDocument().toJson();
    }

    static Document createCursor(int cursorBatchSize) {
        return new Document(BATCH_SIZE, (Object)cursorBatchSize);
    }

    public static class Builder {
        private boolean allowDiskUse;
        private boolean explain;
        @Nullable
        private Document cursor;
        @Nullable
        private Collation collation;

        public Builder allowDiskUse(boolean allowDiskUse) {
            this.allowDiskUse = allowDiskUse;
            return this;
        }

        public Builder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public Builder cursor(Document cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursorBatchSize(int batchSize) {
            this.cursor = AggregationOptions.createCursor(batchSize);
            return this;
        }

        public Builder collation(@Nullable Collation collation) {
            this.collation = collation;
            return this;
        }

        public AggregationOptions build() {
            return new AggregationOptions(this.allowDiskUse, this.explain, this.cursor, this.collation);
        }
    }
}

