/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;

class MetricConversion {
    private static final BigDecimal METERS_MULTIPLIER = new BigDecimal(Metrics.KILOMETERS.getMultiplier()).multiply(new BigDecimal(1000));
    private static final int PRECISION = 8;

    MetricConversion() {
    }

    protected static double getMetersToMetricMultiplier(Metric metric) {
        ConversionMultiplier conversionMultiplier = ConversionMultiplier.builder().from(METERS_MULTIPLIER).to(metric).build();
        return conversionMultiplier.multiplier().doubleValue();
    }

    protected static double getDistanceInMeters(Distance distance) {
        return new BigDecimal(distance.getValue()).multiply(MetricConversion.getMetricToMetersMultiplier(distance.getMetric())).doubleValue();
    }

    private static BigDecimal getMetricToMetersMultiplier(Metric metric) {
        ConversionMultiplier conversionMultiplier = ConversionMultiplier.builder().from(metric).to(METERS_MULTIPLIER).build();
        return conversionMultiplier.multiplier();
    }

    private static class ConversionMultiplierBuilder {
        private Number from;
        private Number to;

        ConversionMultiplierBuilder() {
        }

        ConversionMultiplierBuilder from(Number from) {
            this.from = from;
            return this;
        }

        ConversionMultiplierBuilder from(Metric from) {
            this.from = from.getMultiplier();
            return this;
        }

        ConversionMultiplierBuilder to(Number to) {
            this.to = to;
            return this;
        }

        ConversionMultiplierBuilder to(Metric to) {
            this.to = to.getMultiplier();
            return this;
        }

        ConversionMultiplier build() {
            return new ConversionMultiplier(this.from, this.to);
        }
    }

    private static class ConversionMultiplier {
        private final BigDecimal source;
        private final BigDecimal target;

        ConversionMultiplier(Number source, Number target) {
            this.source = source instanceof BigDecimal ? (BigDecimal)source : new BigDecimal(source.doubleValue());
            this.target = target instanceof BigDecimal ? (BigDecimal)target : new BigDecimal(target.doubleValue());
        }

        BigDecimal multiplier() {
            return this.target.divide(this.source, 8, RoundingMode.HALF_UP);
        }

        static ConversionMultiplierBuilder builder() {
            return new ConversionMultiplierBuilder();
        }
    }
}

