/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class AggregationUtils {
    private static final ParameterBindingDocumentCodec CODEC = new ParameterBindingDocumentCodec();

    static AggregationOptions.Builder applyCollation(AggregationOptions.Builder builder, @Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, parameters, expressionParser, evaluationContextProvider);
        return collation == null ? builder : builder.collation(collation);
    }

    static AggregationOptions.Builder applyMeta(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        Meta meta = queryMethod.getQueryMetaAttributes();
        if (StringUtils.hasText((String)meta.getComment())) {
            builder.comment(meta.getComment());
        }
        if (meta.getCursorBatchSize() != null) {
            builder.cursorBatchSize(meta.getCursorBatchSize());
        }
        return builder;
    }

    static List<AggregationOperation> computePipeline(MongoQueryMethod method, ConvertingParameterAccessor accessor, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        ParameterBindingContext bindingContext = new ParameterBindingContext(accessor::getBindableValue, expressionParser, evaluationContextProvider.getEvaluationContext((Parameters)method.getParameters(), accessor.getValues()));
        ArrayList<AggregationOperation> target = new ArrayList<AggregationOperation>(method.getAnnotatedAggregation().length);
        for (String source : method.getAnnotatedAggregation()) {
            target.add(ctx -> ctx.getMappedObject(CODEC.decode(source, bindingContext), method.getDomainClass()));
        }
        return target;
    }

    static void appendSortIfPresent(List<AggregationOperation> aggregationPipeline, ConvertingParameterAccessor accessor, Class<?> targetType) {
        if (accessor.getSort().isUnsorted()) {
            return;
        }
        aggregationPipeline.add(ctx -> {
            Document sort = new Document();
            for (Sort.Order order : accessor.getSort()) {
                sort.append(order.getProperty(), (Object)(order.isAscending() ? 1 : -1));
            }
            return ctx.getMappedObject(new Document("$sort", (Object)sort), targetType);
        });
    }

    static void appendLimitAndOffsetIfPresent(List<AggregationOperation> aggregationPipeline, ConvertingParameterAccessor accessor) {
        Pageable pageable = accessor.getPageable();
        if (pageable.isUnpaged()) {
            return;
        }
        if (pageable.getOffset() > 0L) {
            aggregationPipeline.add(Aggregation.skip(pageable.getOffset()));
        }
        aggregationPipeline.add(Aggregation.limit(pageable.getPageSize()));
    }

    @Nullable
    static <T> T extractSimpleTypeResult(Document source, Class<T> targetType, MongoConverter converter) {
        if (source.isEmpty()) {
            return null;
        }
        if (source.size() == 1) {
            return AggregationUtils.getPotentiallyConvertedSimpleTypeValue(converter, source.values().iterator().next(), targetType);
        }
        Document intermediate = new Document((Map)source);
        intermediate.remove((Object)"_id");
        if (intermediate.size() == 1) {
            return AggregationUtils.getPotentiallyConvertedSimpleTypeValue(converter, intermediate.values().iterator().next(), targetType);
        }
        for (Map.Entry entry : intermediate.entrySet()) {
            if (entry == null || !ClassUtils.isAssignable(targetType, entry.getValue().getClass())) continue;
            return targetType.cast(entry.getValue());
        }
        throw new IllegalArgumentException(String.format("o_O no entry of type %s found in %s.", targetType.getSimpleName(), source.toJson()));
    }

    @Nullable
    private static <T> T getPotentiallyConvertedSimpleTypeValue(MongoConverter converter, @Nullable Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(targetType, (Object)value)) {
            return (T)value;
        }
        return (T)converter.getConversionService().convert(value, targetType);
    }

    private AggregationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

