/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.util.Assert;

class CriteriaValidator
implements Validator {
    private final CriteriaDefinition criteria;

    static CriteriaValidator of(CriteriaDefinition criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
        return new CriteriaValidator(criteria);
    }

    @Override
    public Document toDocument() {
        return this.criteria.getCriteriaObject();
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDocument());
    }

    private CriteriaValidator(CriteriaDefinition criteria) {
        this.criteria = criteria;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CriteriaValidator)) {
            return false;
        }
        CriteriaValidator other = (CriteriaValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CriteriaDefinition this$criteria = this.criteria;
        CriteriaDefinition other$criteria = other.criteria;
        return !(this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CriteriaValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CriteriaDefinition $criteria = this.criteria;
        result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
        return result;
    }
}

