/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.QuerydslPredicateExecutorSupport;
import org.springframework.data.mongodb.repository.support.ReactiveSpringDataMongodbQuery;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQuerydslMongoPredicateExecutor<T>
extends QuerydslPredicateExecutorSupport<T>
implements ReactiveQuerydslPredicateExecutor<T> {
    private final ReactiveMongoOperations mongoOperations;

    public ReactiveQuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, ReactiveMongoOperations mongoOperations) {
        this(entityInformation, mongoOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public ReactiveQuerydslMongoPredicateExecutor(MongoEntityInformation<T, ?> entityInformation, ReactiveMongoOperations mongoOperations, EntityPathResolver resolver) {
        super(mongoOperations.getConverter(), ReactiveQuerydslMongoPredicateExecutor.pathBuilderFor(resolver.createPath(entityInformation.getJavaType())), entityInformation);
        this.mongoOperations = mongoOperations;
    }

    public Mono<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchOne();
    }

    public Flux<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetch();
    }

    public Flux<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return ((ReactiveSpringDataMongodbQuery)this.createQueryFor(predicate).orderBy((OrderSpecifier[])orders)).fetch();
    }

    public Flux<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.applySorting(this.createQueryFor(predicate), sort).fetch();
    }

    public Flux<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return ((ReactiveSpringDataMongodbQuery)this.createQuery().orderBy((OrderSpecifier[])orders)).fetch();
    }

    public Mono<Long> count(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchCount();
    }

    public Mono<Boolean> exists(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchCount().map(it -> it != 0L);
    }

    private ReactiveSpringDataMongodbQuery<T> createQueryFor(Predicate predicate) {
        return (ReactiveSpringDataMongodbQuery)this.createQuery().where(predicate);
    }

    private ReactiveSpringDataMongodbQuery<T> createQuery() {
        Class javaType = this.typeInformation().getJavaType();
        return new ReactiveSpringDataMongodbQuery(this.mongodbSerializer(), this.mongoOperations, javaType, this.mongoOperations.getCollectionName(javaType));
    }

    private ReactiveSpringDataMongodbQuery<T> applySorting(ReactiveSpringDataMongodbQuery<T> query, Sort sort) {
        this.toOrderSpecifiers(sort).forEach(xva$0 -> query.orderBy(new OrderSpecifier[]{xva$0}));
        return query;
    }
}

