/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.bson.Document;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

class QueryUtils {
    QueryUtils() {
    }

    static Query decorateSort(Query query, Document defaultSort) {
        if (defaultSort.isEmpty()) {
            return query;
        }
        ProxyFactory factory = new ProxyFactory((Object)query);
        factory.addAdvice((Advice)((MethodInterceptor)invocation -> {
            if (!invocation.getMethod().getName().equals("getSortObject")) {
                return invocation.proceed();
            }
            Document combinedSort = new Document((Map)defaultSort);
            combinedSort.putAll((Map)((Document)invocation.proceed()));
            return combinedSort;
        }));
        return (Query)factory.getProxy(query.getClass().getClassLoader());
    }

    static Query applyCollation(Query query, @Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, parameters, expressionParser, evaluationContextProvider);
        return collation == null ? query : query.collation(collation);
    }
}

