/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.BsonRegularExpression;
import org.bson.Document;
import org.bson.types.Binary;
import org.springframework.data.domain.Example;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Criteria
implements CriteriaDefinition {
    private static final Object NOT_SET = new Object();
    private static final int[] FLAG_LOOKUP = new int[65535];
    @Nullable
    private String key;
    private List<Criteria> criteriaChain;
    private LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    @Nullable
    private Object isValue = NOT_SET;

    public Criteria() {
        this.criteriaChain = new ArrayList<Criteria>();
    }

    public Criteria(String key) {
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = key;
    }

    protected Criteria(List<Criteria> criteriaChain, String key) {
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = key;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public static Criteria byExample(Object example) {
        return Criteria.byExample(Example.of((Object)example));
    }

    public static Criteria byExample(Example<?> example) {
        return new Criteria().alike(example);
    }

    public static Criteria matchingDocumentStructure(MongoJsonSchema schema) {
        return new Criteria().andDocumentStructureMatches(schema);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria is(@Nullable Object value) {
        if (!this.isValue.equals(NOT_SET)) {
            throw new InvalidMongoDbApiUsageException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.lastOperatorWasNot()) {
            throw new InvalidMongoDbApiUsageException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        this.isValue = value;
        return this;
    }

    private boolean lastOperatorWasNot() {
        return !this.criteria.isEmpty() && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1]);
    }

    public Criteria ne(@Nullable Object value) {
        this.criteria.put("$ne", value);
        return this;
    }

    public Criteria lt(Object value) {
        this.criteria.put("$lt", value);
        return this;
    }

    public Criteria lte(Object value) {
        this.criteria.put("$lte", value);
        return this;
    }

    public Criteria gt(Object value) {
        this.criteria.put("$gt", value);
        return this;
    }

    public Criteria gte(Object value) {
        this.criteria.put("$gte", value);
        return this;
    }

    public Criteria in(Object ... values) {
        if (values.length > 1 && values[1] instanceof Collection) {
            throw new InvalidMongoDbApiUsageException("You can only pass in one argument of type " + values[1].getClass().getName());
        }
        this.criteria.put("$in", Arrays.asList(values));
        return this;
    }

    public Criteria in(Collection<?> values) {
        this.criteria.put("$in", values);
        return this;
    }

    public Criteria nin(Object ... values) {
        return this.nin(Arrays.asList(values));
    }

    public Criteria nin(Collection<?> values) {
        this.criteria.put("$nin", values);
        return this;
    }

    public Criteria mod(Number value, Number remainder) {
        ArrayList<Number> l = new ArrayList<Number>();
        l.add(value);
        l.add(remainder);
        this.criteria.put("$mod", l);
        return this;
    }

    public Criteria all(Object ... values) {
        return this.all(Arrays.asList(values));
    }

    public Criteria all(Collection<?> values) {
        this.criteria.put("$all", values);
        return this;
    }

    public Criteria size(int size) {
        this.criteria.put("$size", size);
        return this;
    }

    public Criteria exists(boolean value) {
        this.criteria.put("$exists", value);
        return this;
    }

    public Criteria type(int typeNumber) {
        this.criteria.put("$type", typeNumber);
        return this;
    }

    public Criteria type(JsonSchemaObject.Type ... types) {
        Assert.notNull((Object)types, (String)"Types must not be null!");
        Assert.noNullElements((Object[])types, (String)"Types must not contain null.");
        this.criteria.put("$type", Arrays.asList(types).stream().map(JsonSchemaObject.Type::value).collect(Collectors.toList()));
        return this;
    }

    public Criteria not() {
        return this.not(null);
    }

    private Criteria not(@Nullable Object value) {
        this.criteria.put("$not", value);
        return this;
    }

    public Criteria regex(String regex) {
        return this.regex(regex, null);
    }

    public Criteria regex(String regex, @Nullable String options) {
        return this.regex(this.toPattern(regex, options));
    }

    public Criteria regex(Pattern pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        if (this.lastOperatorWasNot()) {
            return this.not(pattern);
        }
        this.isValue = pattern;
        return this;
    }

    public Criteria regex(BsonRegularExpression regex) {
        if (this.lastOperatorWasNot()) {
            return this.not(regex);
        }
        this.isValue = regex;
        return this;
    }

    private Pattern toPattern(String regex, @Nullable String options) {
        Assert.notNull((Object)regex, (String)"Regex string must not be null!");
        return Pattern.compile(regex, Criteria.regexFlags(options));
    }

    public Criteria withinSphere(Circle circle) {
        Assert.notNull((Object)circle, (String)"Circle must not be null!");
        this.criteria.put("$geoWithin", new GeoCommand(new Sphere(circle)));
        return this;
    }

    public Criteria within(Shape shape) {
        Assert.notNull((Object)shape, (String)"Shape must not be null!");
        this.criteria.put("$geoWithin", new GeoCommand(shape));
        return this;
    }

    public Criteria near(Point point) {
        Assert.notNull((Object)point, (String)"Point must not be null!");
        this.criteria.put("$near", point);
        return this;
    }

    public Criteria nearSphere(Point point) {
        Assert.notNull((Object)point, (String)"Point must not be null!");
        this.criteria.put("$nearSphere", point);
        return this;
    }

    public Criteria intersects(GeoJson geoJson) {
        Assert.notNull((Object)geoJson, (String)"GeoJson must not be null!");
        this.criteria.put("$geoIntersects", geoJson);
        return this;
    }

    public Criteria maxDistance(double maxDistance) {
        if (this.createNearCriteriaForCommand("$near", "$maxDistance", maxDistance) || this.createNearCriteriaForCommand("$nearSphere", "$maxDistance", maxDistance)) {
            return this;
        }
        this.criteria.put("$maxDistance", maxDistance);
        return this;
    }

    public Criteria minDistance(double minDistance) {
        if (this.createNearCriteriaForCommand("$near", "$minDistance", minDistance) || this.createNearCriteriaForCommand("$nearSphere", "$minDistance", minDistance)) {
            return this;
        }
        this.criteria.put("$minDistance", minDistance);
        return this;
    }

    public Criteria elemMatch(Criteria criteria) {
        this.criteria.put("$elemMatch", criteria.getCriteriaObject());
        return this;
    }

    public Criteria alike(Example<?> sample) {
        if (StringUtils.hasText((String)this.getKey())) {
            this.criteria.put("$example", sample);
            return this;
        }
        Criteria exampleCriteria = new Criteria();
        exampleCriteria.criteria.put("$example", sample);
        return this.registerCriteriaChainElement(exampleCriteria);
    }

    public Criteria andDocumentStructureMatches(MongoJsonSchema schema) {
        Assert.notNull((Object)schema, (String)"Schema must not be null!");
        Criteria schemaCriteria = new Criteria();
        schemaCriteria.criteria.putAll((Map<String, Object>)schema.toDocument());
        return this.registerCriteriaChainElement(schemaCriteria);
    }

    public BitwiseCriteriaOperators bits() {
        return new BitwiseCriteriaOperatorsImpl(this);
    }

    public Criteria orOperator(Criteria ... criteria) {
        BasicDBList bsonList = this.createCriteriaList(criteria);
        return this.registerCriteriaChainElement(new Criteria("$or").is(bsonList));
    }

    public Criteria norOperator(Criteria ... criteria) {
        BasicDBList bsonList = this.createCriteriaList(criteria);
        return this.registerCriteriaChainElement(new Criteria("$nor").is(bsonList));
    }

    public Criteria andOperator(Criteria ... criteria) {
        BasicDBList bsonList = this.createCriteriaList(criteria);
        return this.registerCriteriaChainElement(new Criteria("$and").is(bsonList));
    }

    private Criteria registerCriteriaChainElement(Criteria criteria) {
        if (this.lastOperatorWasNot()) {
            throw new IllegalArgumentException("operator $not is not allowed around criteria chain element: " + criteria.getCriteriaObject());
        }
        this.criteriaChain.add(criteria);
        return this;
    }

    @Override
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    public Document getCriteriaObject() {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).getSingleCriteriaObject();
        }
        if (CollectionUtils.isEmpty(this.criteriaChain) && !CollectionUtils.isEmpty(this.criteria)) {
            return this.getSingleCriteriaObject();
        }
        Document criteriaObject = new Document();
        for (Criteria c : this.criteriaChain) {
            Document document = c.getSingleCriteriaObject();
            for (String k : document.keySet()) {
                this.setValue(criteriaObject, k, document.get((Object)k));
            }
        }
        return criteriaObject;
    }

    protected Document getSingleCriteriaObject() {
        Document document = new Document();
        boolean not = false;
        for (Map.Entry<String, Object> entry : this.criteria.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Criteria.requiresGeoJsonFormat(value)) {
                value = new Document("$geometry", value);
            }
            if (not) {
                Document notDocument = new Document();
                notDocument.put(key, value);
                document.put("$not", (Object)notDocument);
                not = false;
                continue;
            }
            if ("$not".equals(key) && value == null) {
                not = true;
                continue;
            }
            document.put(key, value);
        }
        if (!StringUtils.hasText((String)this.key)) {
            if (not) {
                return new Document("$not", (Object)document);
            }
            return document;
        }
        Document queryCriteria = new Document();
        if (!NOT_SET.equals(this.isValue)) {
            queryCriteria.put(this.key, this.isValue);
            queryCriteria.putAll((Map)document);
        } else {
            queryCriteria.put(this.key, (Object)document);
        }
        return queryCriteria;
    }

    private BasicDBList createCriteriaList(Criteria[] criteria) {
        BasicDBList bsonList = new BasicDBList();
        for (Criteria c : criteria) {
            bsonList.add((Object)c.getCriteriaObject());
        }
        return bsonList;
    }

    private void setValue(Document document, String key, Object value) {
        Object existing = document.get((Object)key);
        if (existing != null) {
            throw new InvalidMongoDbApiUsageException("Due to limitations of the com.mongodb.BasicDocument, you can't add a second '" + key + "' expression specified as '" + key + " : " + value + "'. Criteria already contains '" + key + " : " + existing + "'.");
        }
        document.put(key, value);
    }

    private boolean createNearCriteriaForCommand(String command, String operation, double maxDistance) {
        if (!this.criteria.containsKey(command)) {
            return false;
        }
        Object existingNearOperationValue = this.criteria.get(command);
        if (existingNearOperationValue instanceof Document) {
            ((Document)existingNearOperationValue).put(operation, (Object)maxDistance);
            return true;
        }
        if (existingNearOperationValue instanceof GeoJson) {
            Document dbo = new Document("$geometry", existingNearOperationValue).append(operation, (Object)maxDistance);
            this.criteria.put(command, dbo);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Criteria that = (Criteria)obj;
        if (this.criteriaChain.size() != that.criteriaChain.size()) {
            return false;
        }
        for (int i = 0; i < this.criteriaChain.size(); ++i) {
            Criteria right;
            Criteria left = this.criteriaChain.get(i);
            if (this.simpleCriteriaEquals(left, right = that.criteriaChain.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean simpleCriteriaEquals(Criteria left, Criteria right) {
        boolean keyEqual = left.key == null ? right.key == null : left.key.equals(right.key);
        boolean criteriaEqual = left.criteria.equals(right.criteria);
        boolean valueEqual = this.isEqual(left.isValue, right.isValue);
        return keyEqual && criteriaEqual && valueEqual;
    }

    private boolean isEqual(@Nullable Object left, @Nullable Object right) {
        if (left == null) {
            return right == null;
        }
        if (left instanceof Pattern) {
            if (!(right instanceof Pattern)) {
                return false;
            }
            Pattern leftPattern = (Pattern)left;
            Pattern rightPattern = (Pattern)right;
            return leftPattern.pattern().equals(rightPattern.pattern()) && leftPattern.flags() == rightPattern.flags();
        }
        if (left instanceof Document) {
            if (!(right instanceof Document)) {
                return false;
            }
            Document leftDocument = (Document)left;
            Document rightDocument = (Document)right;
            Iterator leftIterator = leftDocument.entrySet().iterator();
            Iterator rightIterator = rightDocument.entrySet().iterator();
            while (leftIterator.hasNext() && rightIterator.hasNext()) {
                Map.Entry leftEntry = (Map.Entry)leftIterator.next();
                Map.Entry rightEntry = (Map.Entry)rightIterator.next();
                if (this.isEqual(leftEntry.getKey(), rightEntry.getKey()) && this.isEqual(leftEntry.getValue(), rightEntry.getValue())) continue;
                return false;
            }
            return !leftIterator.hasNext() && !rightIterator.hasNext();
        }
        if (Collection.class.isAssignableFrom(left.getClass())) {
            if (!Collection.class.isAssignableFrom(right.getClass())) {
                return false;
            }
            Collection leftCollection = (Collection)left;
            Collection rightCollection = (Collection)right;
            Iterator leftIterator = leftCollection.iterator();
            Iterator rightIterator = rightCollection.iterator();
            while (leftIterator.hasNext() && rightIterator.hasNext()) {
                if (this.isEqual(leftIterator.next(), rightIterator.next())) continue;
                return false;
            }
            return !leftIterator.hasNext() && !rightIterator.hasNext();
        }
        return ObjectUtils.nullSafeEquals((Object)left, (Object)right);
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)this.key);
        result += this.criteria.hashCode();
        return result += ObjectUtils.nullSafeHashCode((Object)this.isValue);
    }

    private static boolean requiresGeoJsonFormat(Object value) {
        return value instanceof GeoJson || value instanceof GeoCommand && ((GeoCommand)value).getShape() instanceof GeoJson;
    }

    private static int regexFlags(@Nullable String s) {
        int flags = 0;
        if (s == null) {
            return flags;
        }
        for (char f : s.toLowerCase().toCharArray()) {
            flags |= Criteria.regexFlag(f);
        }
        return flags;
    }

    private static int regexFlag(char c) {
        int flag = FLAG_LOOKUP[c];
        if (flag == 0) {
            throw new IllegalArgumentException(String.format("Unrecognized flag [%c]", Character.valueOf(c)));
        }
        return flag;
    }

    static {
        Criteria.FLAG_LOOKUP[103] = 256;
        Criteria.FLAG_LOOKUP[105] = 2;
        Criteria.FLAG_LOOKUP[109] = 8;
        Criteria.FLAG_LOOKUP[115] = 32;
        Criteria.FLAG_LOOKUP[99] = 128;
        Criteria.FLAG_LOOKUP[120] = 4;
        Criteria.FLAG_LOOKUP[100] = 1;
        Criteria.FLAG_LOOKUP[116] = 16;
        Criteria.FLAG_LOOKUP[117] = 64;
    }

    private static class BitwiseCriteriaOperatorsImpl
    implements BitwiseCriteriaOperators {
        private final Criteria target;

        BitwiseCriteriaOperatorsImpl(Criteria target) {
            this.target = target;
        }

        @Override
        public Criteria allClear(int numericBitmask) {
            return this.numericBitmask("$bitsAllClear", numericBitmask);
        }

        @Override
        public Criteria allClear(String bitmask) {
            return this.stringBitmask("$bitsAllClear", bitmask);
        }

        @Override
        public Criteria allClear(List<Integer> positions) {
            return this.positions("$bitsAllClear", positions);
        }

        @Override
        public Criteria allSet(int numericBitmask) {
            return this.numericBitmask("$bitsAllSet", numericBitmask);
        }

        @Override
        public Criteria allSet(String bitmask) {
            return this.stringBitmask("$bitsAllSet", bitmask);
        }

        @Override
        public Criteria allSet(List<Integer> positions) {
            return this.positions("$bitsAllSet", positions);
        }

        @Override
        public Criteria anyClear(int numericBitmask) {
            return this.numericBitmask("$bitsAnyClear", numericBitmask);
        }

        @Override
        public Criteria anyClear(String bitmask) {
            return this.stringBitmask("$bitsAnyClear", bitmask);
        }

        @Override
        public Criteria anyClear(List<Integer> positions) {
            return this.positions("$bitsAnyClear", positions);
        }

        @Override
        public Criteria anySet(int numericBitmask) {
            return this.numericBitmask("$bitsAnySet", numericBitmask);
        }

        @Override
        public Criteria anySet(String bitmask) {
            return this.stringBitmask("$bitsAnySet", bitmask);
        }

        @Override
        public Criteria anySet(List<Integer> positions) {
            return this.positions("$bitsAnySet", positions);
        }

        private Criteria positions(String operator, List<Integer> positions) {
            Assert.notNull(positions, (String)"Positions must not be null!");
            Assert.noNullElements((Object[])positions.toArray(), (String)"Positions must not contain null values.");
            this.target.criteria.put(operator, positions);
            return this.target;
        }

        private Criteria stringBitmask(String operator, String bitmask) {
            Assert.hasText((String)bitmask, (String)"Bitmask must not be null!");
            this.target.criteria.put(operator, new Binary(Base64Utils.decodeFromString((String)bitmask)));
            return this.target;
        }

        private Criteria numericBitmask(String operator, int bitmask) {
            this.target.criteria.put(operator, bitmask);
            return this.target;
        }
    }

    public static interface BitwiseCriteriaOperators {
        public Criteria allClear(int var1);

        public Criteria allClear(String var1);

        public Criteria allClear(List<Integer> var1);

        public Criteria allSet(int var1);

        public Criteria allSet(String var1);

        public Criteria allSet(List<Integer> var1);

        public Criteria anyClear(int var1);

        public Criteria anyClear(String var1);

        public Criteria anyClear(List<Integer> var1);

        public Criteria anySet(int var1);

        public Criteria anySet(String var1);

        public Criteria anySet(List<Integer> var1);
    }
}

