/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GeoJsonMultiLineString
implements GeoJson<Iterable<GeoJsonLineString>> {
    private static final String TYPE = "MultiLineString";
    private List<GeoJsonLineString> coordinates = new ArrayList<GeoJsonLineString>();

    public GeoJsonMultiLineString(List<Point> ... lines) {
        Assert.notEmpty((Object[])lines, (String)"Points for MultiLineString must not be null!");
        for (List<Point> line : lines) {
            this.coordinates.add(new GeoJsonLineString(line));
        }
    }

    public GeoJsonMultiLineString(List<GeoJsonLineString> lines) {
        Assert.notNull(lines, (String)"Lines for MultiLineString must not be null!");
        this.coordinates.addAll(lines);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Iterable<GeoJsonLineString> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoJsonMultiLineString)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.coordinates, ((GeoJsonMultiLineString)obj).coordinates);
    }
}

