/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultDbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.DocumentAccessor;
import org.springframework.data.mongodb.core.convert.DocumentPropertyAccessor;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.Unwrapped;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware {
    private static final String INCOMPATIBLE_TYPES = "Cannot convert %1$s of type %2$s into an instance of %3$s! Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions. Parent object was: %4$s";
    private static final String INVALID_TYPE_TO_READ = "Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter!";
    public static final ClassTypeInformation<Bson> BSON = ClassTypeInformation.from(Bson.class);
    protected static final Logger LOGGER = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final QueryMapper idMapper;
    protected final DbRefResolver dbRefResolver;
    protected final DefaultDbRefProxyHandler dbRefProxyHandler;
    @Nullable
    protected ApplicationContext applicationContext;
    protected MongoTypeMapper typeMapper;
    @Nullable
    protected String mapKeyDotReplacement = null;
    @Nullable
    protected CodecRegistryProvider codecRegistryProvider;
    private SpELContext spELContext;
    @Nullable
    private EntityCallbacks entityCallbacks;

    public MappingMongoConverter(DbRefResolver dbRefResolver, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super((GenericConversionService)new DefaultConversionService());
        Assert.notNull((Object)dbRefResolver, (String)"DbRefResolver must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.dbRefResolver = dbRefResolver;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext, this::getWriteTarget);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DocumentPropertyAccessor.INSTANCE);
        this.dbRefProxyHandler = new DefaultDbRefProxyHandler(this.spELContext, mappingContext, (prop, bson, evaluator, path) -> {
            ConversionContext context = this.getConversionContext(path);
            return this.getValueInternal(context, prop, bson, evaluator);
        });
    }

    protected ConversionContext getConversionContext(ObjectPath path) {
        Assert.notNull((Object)path, (String)"ObjectPath must not be null");
        return new ConversionContext(this.conversions, path, this::readDocument, this::readCollectionOrArray, this::readMap, this::readDBRef, this::getPotentiallyConvertedSimpleRead);
    }

    @Deprecated
    public MappingMongoConverter(MongoDatabaseFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this(new DefaultDbRefResolver(mongoDbFactory), mappingContext);
        this.setCodecRegistryProvider(mongoDbFactory);
    }

    public void setTypeMapper(@Nullable MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    @Override
    public MongoTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setMapKeyDotReplacement(@Nullable String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public void setCodecRegistryProvider(@Nullable CodecRegistryProvider codecRegistryProvider) {
        this.codecRegistryProvider = codecRegistryProvider;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    public <S> S read(Class<S> clazz, Bson bson) {
        return this.read((TypeInformation<S>)ClassTypeInformation.from(clazz), bson);
    }

    protected <S> S read(TypeInformation<S> type, Bson bson) {
        return this.readDocument(this.getConversionContext(ObjectPath.ROOT), bson, type);
    }

    protected <S> S readDocument(ConversionContext context, Bson bson, TypeInformation<? extends S> typeHint) {
        Document document = bson instanceof BasicDBObject ? new Document((Map)((BasicDBObject)bson)) : (Document)bson;
        TypeInformation typeToRead = this.typeMapper.readType(document, typeHint);
        Class rawType = typeToRead.getType();
        if (this.conversions.hasCustomReadTarget(bson.getClass(), rawType)) {
            return (S)this.doConvert(bson, rawType, typeHint.getType());
        }
        if (Document.class.isAssignableFrom(rawType)) {
            return (S)bson;
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            if (bson instanceof DBObject) {
                return (S)bson;
            }
            if (bson instanceof Document) {
                return (S)new BasicDBObject((Map)((Document)bson));
            }
            return (S)bson;
        }
        if (typeToRead.isMap()) {
            return context.convert(bson, typeToRead);
        }
        if (BSON.isAssignableFrom(typeHint)) {
            return (S)bson;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToRead);
        if (entity == null) {
            Optional codec;
            if (this.codecRegistryProvider != null && (codec = this.codecRegistryProvider.getCodecFor(rawType)).isPresent()) {
                return (S)codec.get().decode((BsonReader)new JsonReader(document.toJson()), DecoderContext.builder().build());
            }
            throw new MappingException(String.format(INVALID_TYPE_TO_READ, document, rawType));
        }
        return this.read(context, entity, document);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(ConversionContext context, MongoPersistentEntity<?> entity, DocumentAccessor source, SpELExpressionEvaluator evaluator) {
        AssociationAwareMongoDbPropertyValueProvider provider = new AssociationAwareMongoDbPropertyValueProvider(context, source, evaluator);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, context.getPath().getCurrentObject());
        return new ConverterAwareSpELExpressionParameterValueProvider(context, evaluator, (ConversionService)this.conversionService, (ParameterValueProvider<MongoPersistentProperty>)parameterProvider);
    }

    private <S> S read(ConversionContext context, MongoPersistentEntity<S> entity, Document bson) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)bson, this.spELContext);
        DocumentAccessor documentAccessor = new DocumentAccessor((Bson)bson);
        PreferredConstructor persistenceConstructor = entity.getPersistenceConstructor();
        ParameterValueProvider<MongoPersistentProperty> provider = persistenceConstructor != null && persistenceConstructor.hasParameters() ? this.getParameterProvider(context, entity, documentAccessor, (SpELExpressionEvaluator)evaluator) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        if (entity.requiresPropertyPopulation()) {
            return (S)this.populateProperties(context, entity, documentAccessor, (SpELExpressionEvaluator)evaluator, instance);
        }
        return (S)instance;
    }

    private <S> S populateProperties(ConversionContext context, MongoPersistentEntity<S> entity, DocumentAccessor documentAccessor, SpELExpressionEvaluator evaluator, S instance) {
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), (ConversionService)this.conversionService);
        Object rawId = this.readAndPopulateIdentifier(context, (PersistentPropertyAccessor<?>)accessor, documentAccessor, entity, evaluator);
        ObjectPath currentPath = context.getPath().push(accessor.getBean(), entity, rawId);
        ConversionContext contextToUse = context.withPath(currentPath);
        MongoDbPropertyValueProvider valueProvider = new MongoDbPropertyValueProvider(contextToUse, documentAccessor, evaluator);
        this.readProperties(contextToUse, entity, (PersistentPropertyAccessor<?>)accessor, documentAccessor, valueProvider, evaluator);
        return (S)accessor.getBean();
    }

    @Nullable
    private Object readAndPopulateIdentifier(ConversionContext context, PersistentPropertyAccessor<?> accessor, DocumentAccessor document, MongoPersistentEntity<?> entity, SpELExpressionEvaluator evaluator) {
        Object rawId = document.getRawId(entity);
        if (!entity.hasIdProperty() || rawId == null) {
            return rawId;
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
        if (idProperty.isImmutable() && entity.isConstructorArgument(idProperty)) {
            return rawId;
        }
        accessor.setProperty((PersistentProperty)idProperty, this.readIdValue(context, evaluator, idProperty, rawId));
        return rawId;
    }

    @Nullable
    private Object readIdValue(ConversionContext context, SpELExpressionEvaluator evaluator, MongoPersistentProperty idProperty, Object rawId) {
        String expression = idProperty.getSpelExpression();
        Object resolvedValue = expression != null ? evaluator.evaluate(expression) : rawId;
        return resolvedValue != null ? this.readValue(context, resolvedValue, idProperty.getTypeInformation()) : null;
    }

    private void readProperties(ConversionContext context, MongoPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, DocumentAccessor documentAccessor, MongoDbPropertyValueProvider valueProvider, SpELExpressionEvaluator evaluator) {
        DbRefResolverCallback callback = null;
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty prop = (MongoPersistentProperty)iterator.next();
            if (prop.isAssociation() && !entity.isConstructorArgument(prop)) {
                if (callback == null) {
                    callback = this.getDbRefResolverCallback(context, documentAccessor, evaluator);
                }
                this.readAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, documentAccessor, this.dbRefProxyHandler, callback);
                continue;
            }
            if (prop.isUnwrapped()) {
                accessor.setProperty((PersistentProperty)prop, this.readUnwrapped(context, documentAccessor, prop, (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)prop)));
                continue;
            }
            if (entity.isIdProperty(prop) || entity.isConstructorArgument(prop) || !documentAccessor.hasValue(prop)) continue;
            if (prop.isAssociation()) {
                if (callback == null) {
                    callback = this.getDbRefResolverCallback(context, documentAccessor, evaluator);
                }
                this.readAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, documentAccessor, this.dbRefProxyHandler, callback);
                continue;
            }
            accessor.setProperty((PersistentProperty)prop, valueProvider.getPropertyValue(prop));
        }
    }

    private DbRefResolverCallback getDbRefResolverCallback(ConversionContext context, DocumentAccessor documentAccessor, SpELExpressionEvaluator evaluator) {
        return new DefaultDbRefResolverCallback(documentAccessor.getDocument(), context.getPath(), evaluator, (prop, bson, e, path) -> this.getValueInternal(context, prop, bson, e));
    }

    private void readAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor<?> accessor, DocumentAccessor documentAccessor, DbRefProxyHandler handler, DbRefResolverCallback callback) {
        MongoPersistentProperty property = (MongoPersistentProperty)association.getInverse();
        Object value = documentAccessor.get(property);
        if (value == null) {
            return;
        }
        com.mongodb.DBRef dbref = value instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)value : null;
        accessor.setProperty((PersistentProperty)property, this.dbRefResolver.resolveDbRef(property, dbref, callback, handler));
    }

    @Nullable
    private Object readUnwrapped(ConversionContext context, DocumentAccessor documentAccessor, MongoPersistentProperty prop, MongoPersistentEntity<?> unwrappedEntity) {
        if (((Unwrapped)prop.findAnnotation(Unwrapped.class)).onEmpty().equals((Object)Unwrapped.OnEmpty.USE_EMPTY)) {
            return this.read(context, unwrappedEntity, (Document)documentAccessor.getDocument());
        }
        Iterator iterator = unwrappedEntity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty persistentProperty = (MongoPersistentProperty)iterator.next();
            if (!documentAccessor.hasValue(persistentProperty)) continue;
            return this.read(context, unwrappedEntity, (Document)documentAccessor.getDocument());
        }
        return null;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, @Nullable MongoPersistentProperty referringProperty) {
        if (referringProperty != null) {
            DBRef annotation = referringProperty.getDBRef();
            Assert.isTrue((annotation != null ? 1 : 0) != 0, (String)"The referenced property has to be mapped with @DBRef!");
        }
        if (object instanceof LazyLoadingProxy) {
            return ((LazyLoadingProxy)object).toDBRef();
        }
        return this.createDBRef(object, referringProperty);
    }

    public void write(Object obj, Bson bson) {
        if (null == obj) {
            return;
        }
        Class entityType = ClassUtils.getUserClass(obj.getClass());
        ClassTypeInformation type = ClassTypeInformation.from((Class)entityType);
        Object target = obj instanceof LazyLoadingProxy ? ((LazyLoadingProxy)obj).getTarget() : obj;
        this.writeInternal(target, bson, (TypeInformation<?>)type);
        BsonUtils.removeNullId(bson);
        if (this.requiresTypeHint(entityType)) {
            this.typeMapper.writeType((TypeInformation)type, bson);
        }
    }

    private boolean requiresTypeHint(Class<?> type) {
        return !this.conversions.isSimpleType(type) && !ClassUtils.isAssignable(Collection.class, type) && !this.conversions.hasCustomWriteTarget(type, Document.class);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> entityType = obj.getClass();
        Optional customTarget = this.conversions.getCustomWriteTarget(entityType, Document.class);
        if (customTarget.isPresent()) {
            Document result = this.doConvert(obj, Document.class);
            BsonUtils.addAllToMap(bson, result);
            return;
        }
        if (Map.class.isAssignableFrom(entityType)) {
            this.writeMapInternal((Map)obj, bson, (TypeInformation<?>)ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(entityType)) {
            this.writeCollectionInternal((Collection)obj, (TypeInformation<?>)ClassTypeInformation.LIST, (Collection)bson);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityType);
        this.writeInternal(obj, bson, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, bson);
    }

    protected void writeInternal(@Nullable Object obj, Bson bson, @Nullable MongoPersistentEntity<?> entity) {
        Object value;
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(obj);
        DocumentAccessor dbObjectAccessor = new DocumentAccessor(bson);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null && !dbObjectAccessor.hasValue(idProperty) && (value = this.idMapper.convertId(accessor.getProperty((PersistentProperty)idProperty), idProperty.getFieldType())) != null) {
            dbObjectAccessor.put(idProperty, value);
        }
        this.writeProperties(bson, entity, accessor, dbObjectAccessor, idProperty);
    }

    private void writeProperties(Bson bson, MongoPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, DocumentAccessor dbObjectAccessor, @Nullable MongoPersistentProperty idProperty) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty prop = (MongoPersistentProperty)iterator.next();
            if (prop.equals(idProperty) || !prop.isWritable()) continue;
            if (prop.isAssociation()) {
                this.writeAssociation((Association<MongoPersistentProperty>)prop.getRequiredAssociation(), accessor, dbObjectAccessor);
                continue;
            }
            Object value = accessor.getProperty((PersistentProperty)prop);
            if (value == null) continue;
            if (!this.conversions.isSimpleType(value.getClass())) {
                this.writePropertyInternal(value, dbObjectAccessor, prop);
                continue;
            }
            this.writeSimpleInternal(value, bson, prop);
        }
    }

    private void writeAssociation(Association<MongoPersistentProperty> association, PersistentPropertyAccessor<?> accessor, DocumentAccessor dbObjectAccessor) {
        MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
        this.writePropertyInternal(accessor.getProperty((PersistentProperty)inverseProp), dbObjectAccessor, inverseProp);
    }

    protected void writePropertyInternal(@Nullable Object obj, DocumentAccessor accessor, MongoPersistentProperty prop) {
        Optional basicTargetType;
        if (obj == null) {
            return;
        }
        ClassTypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (prop.isUnwrapped()) {
            Document target = new Document();
            this.writeInternal(obj, (Bson)target, (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)prop));
            accessor.putAll(target);
            return;
        }
        if (valueType.isCollectionLike()) {
            List<Object> collectionInternal = this.createCollection(BsonUtils.asCollection(obj), prop);
            accessor.put(prop, collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            Bson mapDbObj = this.createMap((Map)obj, prop);
            accessor.put(prop, mapDbObj);
            return;
        }
        if (prop.isDbReference()) {
            com.mongodb.DBRef dbRefObj = null;
            if (obj instanceof LazyLoadingProxy) {
                dbRefObj = ((LazyLoadingProxy)obj).toDBRef();
            }
            dbRefObj = dbRefObj != null ? dbRefObj : this.createDBRef(obj, prop);
            accessor.put(prop, dbRefObj);
            return;
        }
        if (obj instanceof LazyLoadingProxy) {
            obj = ((LazyLoadingProxy)obj).getTarget();
        }
        if ((basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass())).isPresent()) {
            accessor.put(prop, this.doConvert(obj, (Class)basicTargetType.get()));
            return;
        }
        MongoPersistentEntity entity = valueType.isSubTypeOf(prop.getType()) ? (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        Object existingValue = accessor.get(prop);
        Document document = existingValue instanceof Document ? (Document)existingValue : new Document();
        this.writeInternal(obj, (Bson)document, entity);
        this.addCustomTypeKeyIfNecessary((TypeInformation<?>)ClassTypeInformation.from((Class)prop.getRawType()), obj, (Bson)document);
        accessor.put(prop, document);
    }

    protected List<Object> createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            if (property.hasExplicitWriteTarget()) {
                return this.writeCollectionInternal(collection, new FieldTypeInformation(property), new ArrayList());
            }
            return this.writeCollectionInternal(collection, (TypeInformation<?>)property.getTypeInformation(), (Collection<?>)new BasicDBList());
        }
        ArrayList<Object> dbList = new ArrayList<Object>(collection.size());
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property);
            dbList.add(dbRef);
        }
        return dbList;
    }

    protected Bson createMap(Map<Object, Object> map, MongoPersistentProperty property) {
        Assert.notNull(map, (String)"Given map must not be null!");
        Assert.notNull((Object)property, (String)"PersistentProperty must not be null!");
        if (!property.isDbReference()) {
            return this.writeMapInternal(map, (Bson)new Document(), property.getTypeInformation());
        }
        Document document = new Document();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key.toString());
                document.put(simpleKey, value != null ? this.createDBRef(value, property) : null);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return document;
    }

    private List<Object> writeCollectionInternal(Collection<?> source, @Nullable TypeInformation<?> type, Collection<?> sink) {
        List<Object> collection;
        TypeInformation componentType = null;
        List<Object> list = collection = sink instanceof List ? (List<Object>)sink : new ArrayList(sink);
        if (type != null) {
            componentType = type.getComponentType();
        }
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                collection.add(this.getPotentiallyConvertedSimpleWrite(element, componentType != null ? componentType.getType() : Object.class));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                collection.add(this.writeCollectionInternal(BsonUtils.asCollection(element), (TypeInformation<?>)componentType, (Collection<?>)new BasicDBList()));
                continue;
            }
            Document document = new Document();
            this.writeInternal(element, (Bson)document, componentType);
            collection.add(document);
        }
        return collection;
    }

    protected Bson writeMapInternal(Map<Object, Object> obj, Bson bson, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.prepareMapKey(key);
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, bson, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    BsonUtils.addToMap(bson, simpleKey, this.writeCollectionInternal(BsonUtils.asCollection(val), (TypeInformation<?>)propertyType.getMapValueType(), (Collection<?>)new BasicDBList()));
                    continue;
                }
                Document document = new Document();
                ClassTypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (Bson)document, (TypeInformation<?>)valueTypeInfo);
                BsonUtils.addToMap(bson, simpleKey, document);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return bson;
    }

    private String prepareMapKey(Object key) {
        Assert.notNull((Object)key, (String)"Map key must not be null!");
        String convertedKey = this.potentiallyConvertMapKey(key);
        return this.potentiallyEscapeMapKey(convertedKey);
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return StringUtils.replace((String)source, (String)".", (String)this.mapKeyDotReplacement);
    }

    private String potentiallyConvertMapKey(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        return this.conversions.hasCustomWriteTarget(key.getClass(), String.class) ? (String)this.getPotentiallyConvertedSimpleWrite(key, Object.class) : key.toString();
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : StringUtils.replace((String)source, (String)this.mapKeyDotReplacement, (String)".");
    }

    protected void addCustomTypeKeyIfNecessary(@Nullable TypeInformation<?> type, Object value, Bson bson) {
        boolean notTheSameClass;
        Class reference = type != null ? type.getRequiredActualType().getType() : Object.class;
        Class valueType = ClassUtils.getUserClass(value.getClass());
        boolean bl = notTheSameClass = !valueType.equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(valueType, bson);
        }
    }

    private void writeSimpleInternal(@Nullable Object value, Bson bson, String key) {
        BsonUtils.addToMap(bson, key, this.getPotentiallyConvertedSimpleWrite(value, Object.class));
    }

    private void writeSimpleInternal(@Nullable Object value, Bson bson, MongoPersistentProperty property) {
        DocumentAccessor accessor = new DocumentAccessor(bson);
        accessor.put(property, this.getPotentiallyConvertedSimpleWrite(value, property.hasExplicitWriteTarget() ? property.getFieldType() : Object.class));
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, @Nullable Class<?> typeHint) {
        Optional customTarget;
        if (value == null) {
            return null;
        }
        if (typeHint != null && Object.class != typeHint && this.conversionService.canConvert(value.getClass(), typeHint)) {
            value = this.doConvert(value, typeHint);
        }
        if ((customTarget = this.conversions.getCustomWriteTarget(value.getClass())).isPresent()) {
            return this.doConvert(value, (Class)customTarget.get());
        }
        if (ObjectUtils.isArray((Object)value)) {
            if (value instanceof byte[]) {
                return value;
            }
            return BsonUtils.asCollection(value);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    protected Object getPotentiallyConvertedSimpleRead(Object value, TypeInformation<?> target) {
        return this.getPotentiallyConvertedSimpleRead(value, target.getType());
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, @Nullable Class<?> target) {
        if (target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.doConvert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.doConvert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, @Nullable MongoPersistentProperty property) {
        Assert.notNull((Object)target, (String)"Target object must not be null!");
        if (target instanceof com.mongodb.DBRef) {
            return (com.mongodb.DBRef)target;
        }
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        MongoPersistentEntity mongoPersistentEntity = targetEntity = targetEntity != null ? targetEntity : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentEntity entity = targetEntity;
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            Object id;
            Object object = id = target.getClass().equals(idProperty.getType()) ? target : entity.getPropertyAccessor(target).getProperty((PersistentProperty)idProperty);
            if (null == id) {
                throw new MappingException("Cannot create a reference to an object with a NULL id.");
            }
            return this.dbRefResolver.createDbRef(property == null ? null : property.getDBRef(), entity, this.idMapper.convertId(id, idProperty != null ? idProperty.getFieldType() : ObjectId.class));
        }
        throw new MappingException("No id property found on class " + entity.getType());
    }

    @Nullable
    private Object getValueInternal(ConversionContext context, MongoPersistentProperty prop, Bson bson, SpELExpressionEvaluator evaluator) {
        return new MongoDbPropertyValueProvider(context, bson, evaluator).getPropertyValue(prop);
    }

    protected Object readCollectionOrArray(ConversionContext context, Collection<?> source, TypeInformation<?> targetType) {
        Collection items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
        ClassTypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : ClassTypeInformation.OBJECT;
        Class rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection((Class)collectionType, (Class)rawComponentType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
        }
        if (!com.mongodb.DBRef.class.equals((Object)rawComponentType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(source)) {
            List objects = this.bulkReadAndConvertDBRefs(context, (List)source, (TypeInformation<?>)componentType);
            return this.getPotentiallyConvertedSimpleRead(objects, targetType.getType());
        }
        for (Object element : source) {
            items.add(context.convert(element, componentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    @Deprecated
    protected Map<Object, Object> readMap(TypeInformation<?> type, Bson bson, ObjectPath path) {
        return this.readMap(this.getConversionContext(path), bson, type);
    }

    protected Map<Object, Object> readMap(ConversionContext context, Bson bson, TypeInformation<?> targetType) {
        Assert.notNull((Object)bson, (String)"Document must not be null!");
        Assert.notNull(targetType, (String)"TypeInformation must not be null!");
        Class mapType = this.typeMapper.readType(bson, targetType).getType();
        TypeInformation keyType = targetType.getComponentType();
        ClassTypeInformation valueType = targetType.getMapValueType() == null ? ClassTypeInformation.OBJECT : targetType.getRequiredMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : Object.class;
        Class rawValueType = valueType.getType();
        Map<String, Object> sourceMap = BsonUtils.asMap(bson);
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)sourceMap.keySet().size());
        if (!com.mongodb.DBRef.class.equals((Object)rawValueType) && MappingMongoConverter.isCollectionOfDbRefWhereBulkFetchIsPossible(sourceMap.values())) {
            this.bulkReadAndConvertDBRefMapIntoTarget(context, (TypeInformation<?>)valueType, sourceMap, map);
            return map;
        }
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            Object value;
            if (this.typeMapper.isTypeKey(entry.getKey())) continue;
            String key = this.potentiallyUnescapeMapKey(entry.getKey());
            if (!rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.doConvert(key, rawKeyType);
            }
            map.put(key, (value = entry.getValue()) == null ? value : context.convert(value, valueType));
        }
        return map;
    }

    @Override
    @Nullable
    public Object convertToMongoType(@Nullable Object obj, @Nullable TypeInformation<?> typeInformation) {
        if (obj == null) {
            return null;
        }
        Optional target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target.isPresent()) {
            return this.doConvert(obj, (Class)target.get());
        }
        if (this.conversions.isSimpleType(obj.getClass())) {
            Class conversionTargetType = typeInformation != null && this.conversions.isSimpleType(typeInformation.getType()) ? typeInformation.getType() : Object.class;
            return this.getPotentiallyConvertedSimpleWrite(obj, conversionTargetType);
        }
        if (obj instanceof List) {
            return this.maybeConvertList((List)obj, typeInformation);
        }
        if (obj instanceof Document) {
            Document newValueDocument = new Document();
            for (String vk : ((Document)obj).keySet()) {
                Object o = ((Document)obj).get((Object)vk);
                newValueDocument.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDocument;
        }
        if (obj instanceof DBObject) {
            Document newValueDbo = new Document();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o, typeInformation));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            Document result = new Document();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue(), typeInformation));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj), typeInformation);
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj, typeInformation);
        }
        Document newDocument = new Document();
        this.write(obj, (Bson)newDocument);
        if (typeInformation == null) {
            return this.removeTypeInfo(newDocument, true);
        }
        if (typeInformation.getType().equals(NestedDocument.class)) {
            return this.removeTypeInfo(newDocument, false);
        }
        return !obj.getClass().equals(typeInformation.getType()) ? newDocument : this.removeTypeInfo(newDocument, true);
    }

    @Override
    public Object convertToMongoType(@Nullable Object obj, MongoPersistentEntity entity) {
        Document newDocument = new Document();
        this.writeInternal(obj, (Bson)newDocument, entity);
        return newDocument;
    }

    public List<Object> maybeConvertList(Iterable<?> source, @Nullable TypeInformation<?> typeInformation) {
        ArrayList<Object> newDbl = new ArrayList<Object>();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element, typeInformation));
        }
        return newDbl;
    }

    private Object removeTypeInfo(Object object, boolean recursively) {
        if (!(object instanceof Document)) {
            return object;
        }
        Document document = (Document)object;
        String keyToRemove = null;
        for (String key : document.keySet()) {
            if (recursively) {
                Object value = document.get((Object)key);
                if (value instanceof BasicDBList) {
                    for (Object element : (BasicDBList)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else if (value instanceof List) {
                    for (Object element : (List)value) {
                        this.removeTypeInfo(element, recursively);
                    }
                } else {
                    this.removeTypeInfo(value, recursively);
                }
            }
            if (!this.typeMapper.isTypeKey(key)) continue;
            keyToRemove = key;
            if (recursively) continue;
            break;
        }
        if (keyToRemove != null) {
            document.remove(keyToRemove);
        }
        return document;
    }

    @Nullable
    <T> T readValue(ConversionContext context, @Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        Assert.notNull(type, (String)"TypeInformation must not be null");
        Class rawType = type.getType();
        if (this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
            return this.doConvert(value, rawType);
        }
        if (value instanceof com.mongodb.DBRef) {
            return (T)this.readDBRef(context, (com.mongodb.DBRef)value, type);
        }
        return (T)context.convert(value, type);
    }

    @Nullable
    private Object readDBRef(ConversionContext context, @Nullable com.mongodb.DBRef dbref, TypeInformation<?> type) {
        Object object;
        if (type.getType().equals(com.mongodb.DBRef.class)) {
            return dbref;
        }
        ObjectPath path = context.getPath();
        Object v0 = object = dbref == null ? null : path.getPathItem(dbref.getId(), dbref.getCollectionName(), type.getType());
        if (object != null) {
            return object;
        }
        List result = this.bulkReadAndConvertDBRefs(context, Collections.singletonList(dbref), type);
        return CollectionUtils.isEmpty(result) ? null : result.iterator().next();
    }

    private void bulkReadAndConvertDBRefMapIntoTarget(ConversionContext context, TypeInformation<?> valueType, Map<String, Object> sourceMap, Map<Object, Object> targetMap) {
        LinkedHashMap<String, Object> referenceMap = new LinkedHashMap<String, Object>(sourceMap);
        List convertedObjects = this.bulkReadAndConvertDBRefs(context.withPath(ObjectPath.ROOT), new ArrayList<Object>(referenceMap.values()), valueType);
        int index = 0;
        for (String key : referenceMap.keySet()) {
            targetMap.put(key, convertedObjects.get(index));
            ++index;
        }
    }

    private <T> List<T> bulkReadAndConvertDBRefs(ConversionContext context, List<com.mongodb.DBRef> dbrefs, TypeInformation<?> type) {
        if (CollectionUtils.isEmpty(dbrefs)) {
            return Collections.emptyList();
        }
        List<Document> referencedRawDocuments = dbrefs.size() == 1 ? Collections.singletonList(this.readRef(dbrefs.iterator().next())) : this.bulkReadRefs(dbrefs);
        String collectionName = dbrefs.iterator().next().getCollectionName();
        ArrayList<Object> targetList = new ArrayList<Object>(dbrefs.size());
        for (Document document : referencedRawDocuments) {
            Object target = null;
            if (document != null) {
                this.maybeEmitEvent(new AfterLoadEvent(document, type.getType(), collectionName));
                target = this.readDocument(context, (Bson)document, type);
            }
            if (target != null) {
                this.maybeEmitEvent(new AfterConvertEvent<Object>(document, target, collectionName));
                target = this.maybeCallAfterConvert(target, document, collectionName);
            }
            targetList.add(target);
        }
        return targetList;
    }

    private void maybeEmitEvent(MongoMappingEvent<?> event) {
        if (this.canPublishEvent()) {
            this.applicationContext.publishEvent(event);
        }
    }

    private boolean canPublishEvent() {
        return this.applicationContext != null;
    }

    protected <T> T maybeCallAfterConvert(T object, Document document, String collection) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, object, new Object[]{document, collection});
        }
        return object;
    }

    @Nullable
    Document readRef(com.mongodb.DBRef ref) {
        return this.dbRefResolver.fetch(ref);
    }

    List<Document> bulkReadRefs(List<com.mongodb.DBRef> references) {
        return this.dbRefResolver.bulkFetch(references);
    }

    public Class<?> getWriteTarget(Class<?> source) {
        return this.conversions.getCustomWriteTarget(source).orElse(source);
    }

    public MappingMongoConverter with(MongoDatabaseFactory dbFactory) {
        MappingMongoConverter target = new MappingMongoConverter(new DefaultDbRefResolver(dbFactory), this.mappingContext);
        target.applicationContext = this.applicationContext;
        target.conversions = this.conversions;
        target.spELContext = this.spELContext;
        target.setInstantiators(this.instantiators);
        target.typeMapper = this.typeMapper;
        target.setCodecRegistryProvider(dbFactory);
        target.afterPropertiesSet();
        return target;
    }

    private <T> T doConvert(Object value, Class<? extends T> target) {
        return this.doConvert(value, target, null);
    }

    private <T> T doConvert(Object value, Class<? extends T> target, @Nullable Class<? extends T> fallback) {
        if (this.conversionService.canConvert(value.getClass(), target) || fallback == null) {
            return (T)this.conversionService.convert(value, target);
        }
        return (T)this.conversionService.convert(value, fallback);
    }

    private static boolean isCollectionOfDbRefWhereBulkFetchIsPossible(Iterable<?> source) {
        Assert.notNull(source, (String)"Iterable of DBRefs must not be null!");
        HashSet<String> collectionsFound = new HashSet<String>();
        for (Object dbObjItem : source) {
            if (!(dbObjItem instanceof com.mongodb.DBRef)) {
                return false;
            }
            collectionsFound.add(((com.mongodb.DBRef)dbObjItem).getCollectionName());
            if (collectionsFound.size() <= 1) continue;
            return false;
        }
        return true;
    }

    protected static class ConversionContext {
        private final CustomConversions conversions;
        private final ObjectPath path;
        private final ContainerValueConverter<Bson> documentConverter;
        private final ContainerValueConverter<Collection<?>> collectionConverter;
        private final ContainerValueConverter<Bson> mapConverter;
        private final ContainerValueConverter<com.mongodb.DBRef> dbRefConverter;
        private final ValueConverter<Object> elementConverter;

        ConversionContext(CustomConversions customConversions, ObjectPath path, ContainerValueConverter<Bson> documentConverter, ContainerValueConverter<Collection<?>> collectionConverter, ContainerValueConverter<Bson> mapConverter, ContainerValueConverter<com.mongodb.DBRef> dbRefConverter, ValueConverter<Object> elementConverter) {
            this.conversions = customConversions;
            this.path = path;
            this.documentConverter = documentConverter;
            this.collectionConverter = collectionConverter;
            this.mapConverter = mapConverter;
            this.dbRefConverter = dbRefConverter;
            this.elementConverter = elementConverter;
        }

        public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            Assert.notNull(typeHint, (String)"TypeInformation must not be null");
            if (this.conversions.hasCustomReadTarget(source.getClass(), typeHint.getType())) {
                return (S)this.elementConverter.convert(source, typeHint);
            }
            if (source instanceof Collection) {
                Class rawType = typeHint.getType();
                if (!(Object.class.equals((Object)rawType) || rawType.isArray() || ClassUtils.isAssignable(Iterable.class, (Class)rawType))) {
                    throw new MappingException(String.format(MappingMongoConverter.INCOMPATIBLE_TYPES, source, source.getClass(), rawType, this.getPath()));
                }
                if (typeHint.isCollectionLike() || typeHint.getType().isAssignableFrom(Collection.class)) {
                    return (S)this.collectionConverter.convert(this, (Collection)source, typeHint);
                }
            }
            if (typeHint.isMap()) {
                return (S)this.mapConverter.convert(this, (Bson)source, typeHint);
            }
            if (source instanceof com.mongodb.DBRef) {
                return (S)this.dbRefConverter.convert(this, (com.mongodb.DBRef)source, typeHint);
            }
            if (source instanceof Collection) {
                throw new MappingException(String.format(MappingMongoConverter.INCOMPATIBLE_TYPES, source, BasicDBList.class, typeHint.getType(), this.getPath()));
            }
            if (source instanceof Bson) {
                return (S)this.documentConverter.convert(this, (Bson)source, typeHint);
            }
            return (S)this.elementConverter.convert(source, typeHint);
        }

        public ConversionContext withPath(ObjectPath currentPath) {
            Assert.notNull((Object)currentPath, (String)"ObjectPath must not be null");
            return new ConversionContext(this.conversions, currentPath, this.documentConverter, this.collectionConverter, this.mapConverter, this.dbRefConverter, this.elementConverter);
        }

        public ObjectPath getPath() {
            return this.path;
        }

        static interface ContainerValueConverter<T> {
            public Object convert(ConversionContext var1, T var2, TypeInformation<?> var3);
        }

        static interface ValueConverter<T> {
            public Object convert(T var1, TypeInformation<?> var2);
        }
    }

    private static class FieldTypeInformation<S>
    implements TypeInformation<S> {
        private final MongoPersistentProperty persistentProperty;
        private final TypeInformation<S> delegate;

        public FieldTypeInformation(MongoPersistentProperty property) {
            this.persistentProperty = property;
            this.delegate = property.getTypeInformation();
        }

        public List<TypeInformation<?>> getParameterTypes(Constructor constructor) {
            return this.persistentProperty.getTypeInformation().getParameterTypes(constructor);
        }

        public TypeInformation<?> getProperty(String property) {
            return this.delegate.getProperty(property);
        }

        public boolean isCollectionLike() {
            return this.delegate.isCollectionLike();
        }

        public TypeInformation<?> getComponentType() {
            return ClassTypeInformation.from(this.persistentProperty.getFieldType());
        }

        public boolean isMap() {
            return this.delegate.isMap();
        }

        public TypeInformation<?> getMapValueType() {
            return ClassTypeInformation.from(this.persistentProperty.getFieldType());
        }

        public Class<S> getType() {
            return this.delegate.getType();
        }

        public ClassTypeInformation<?> getRawTypeInformation() {
            return this.delegate.getRawTypeInformation();
        }

        public TypeInformation<?> getActualType() {
            return this.delegate.getActualType();
        }

        public TypeInformation<?> getReturnType(Method method) {
            return this.delegate.getReturnType(method);
        }

        public List<TypeInformation<?>> getParameterTypes(Method method) {
            return this.delegate.getParameterTypes(method);
        }

        public TypeInformation<?> getSuperTypeInformation(Class superType) {
            return this.delegate.getSuperTypeInformation(superType);
        }

        public boolean isAssignableFrom(TypeInformation target) {
            return this.delegate.isAssignableFrom(target);
        }

        public List<TypeInformation<?>> getTypeArguments() {
            return this.delegate.getTypeArguments();
        }

        public TypeInformation<? extends S> specialize(ClassTypeInformation type) {
            return this.delegate.specialize(type);
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<MongoPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return null;
        }
    }

    static class NestedDocument {
        NestedDocument() {
        }
    }

    private static class ConverterAwareSpELExpressionParameterValueProvider
    extends SpELExpressionParameterValueProvider<MongoPersistentProperty> {
        private final ConversionContext context;

        public ConverterAwareSpELExpressionParameterValueProvider(ConversionContext context, SpELExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<MongoPersistentProperty> delegate) {
            super(evaluator, conversionService, delegate);
            Assert.notNull((Object)context, (String)"ConversionContext must no be null!");
            this.context = context;
        }

        protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, MongoPersistentProperty> parameter) {
            return (T)this.context.convert(object, parameter.getType());
        }
    }

    class AssociationAwareMongoDbPropertyValueProvider
    extends MongoDbPropertyValueProvider {
        AssociationAwareMongoDbPropertyValueProvider(ConversionContext context, DocumentAccessor source, SpELExpressionEvaluator evaluator) {
            super(context, source, evaluator);
        }

        @Override
        @Nullable
        public <T> T getPropertyValue(MongoPersistentProperty property) {
            if (property.isDbReference() && property.getDBRef().lazy()) {
                Object rawRefValue = this.accessor.get(property);
                if (rawRefValue == null) {
                    return null;
                }
                DefaultDbRefResolverCallback callback = new DefaultDbRefResolverCallback(this.accessor.getDocument(), this.context.getPath(), this.evaluator, (prop, bson, evaluator, path) -> MappingMongoConverter.this.getValueInternal(this.context, prop, bson, evaluator));
                com.mongodb.DBRef dbref = rawRefValue instanceof com.mongodb.DBRef ? (com.mongodb.DBRef)rawRefValue : null;
                return (T)MappingMongoConverter.this.dbRefResolver.resolveDbRef(property, dbref, callback, MappingMongoConverter.this.dbRefProxyHandler);
            }
            return super.getPropertyValue(property);
        }
    }

    static class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        final ConversionContext context;
        final DocumentAccessor accessor;
        final SpELExpressionEvaluator evaluator;

        MongoDbPropertyValueProvider(ConversionContext context, Bson source, SpELExpressionEvaluator evaluator) {
            this(context, new DocumentAccessor(source), evaluator);
        }

        MongoDbPropertyValueProvider(ConversionContext context, DocumentAccessor accessor, SpELExpressionEvaluator evaluator) {
            Assert.notNull((Object)context, (String)"ConversionContext must no be null!");
            Assert.notNull((Object)accessor, (String)"DocumentAccessor must no be null!");
            Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null!");
            this.context = context;
            this.accessor = accessor;
            this.evaluator = evaluator;
        }

        @Nullable
        public <T> T getPropertyValue(MongoPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.accessor.get(property);
            if (value == null) {
                return null;
            }
            return (T)this.context.convert(value, property.getTypeInformation());
        }
    }
}

