/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.DefaultReferenceResolver;
import org.springframework.data.mongodb.core.convert.MongoDatabaseFactoryReferenceLoader;
import org.springframework.data.mongodb.core.convert.ReferenceLoader;
import org.springframework.data.mongodb.core.convert.ReferenceResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultDbRefResolver
extends DefaultReferenceResolver
implements DbRefResolver,
ReferenceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDbRefResolver.class);
    private final MongoDatabaseFactory mongoDbFactory;

    public DefaultDbRefResolver(MongoDatabaseFactory mongoDbFactory) {
        super(new MongoDatabaseFactoryReferenceLoader(mongoDbFactory), mongoDbFactory.getExceptionTranslator());
        Assert.notNull((Object)mongoDbFactory, (String)"MongoDbFactory translator must not be null!");
        this.mongoDbFactory = mongoDbFactory;
    }

    @Override
    public Object resolveDbRef(MongoPersistentProperty property, @Nullable DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        Assert.notNull((Object)callback, (String)"Callback must not be null!");
        Assert.notNull((Object)handler, (String)"Handler must not be null!");
        if (this.isLazyDbRef(property)) {
            return this.createLazyLoadingProxy(property, dbref, callback, handler);
        }
        return callback.resolve(property);
    }

    @Override
    public Document fetch(DBRef dbRef) {
        return this.getReferenceLoader().fetchOne(ReferenceLoader.DocumentReferenceQuery.forSingleDocument(Filters.eq((String)"_id", (Object)dbRef.getId())), ReferenceResolver.ReferenceCollection.fromDBRef(dbRef));
    }

    @Override
    public List<Document> bulkFetch(List<DBRef> refs) {
        Assert.notNull((Object)this.mongoDbFactory, (String)"Factory must not be null!");
        Assert.notNull(refs, (String)"DBRef to fetch must not be null!");
        if (refs.isEmpty()) {
            return Collections.emptyList();
        }
        String collection = refs.iterator().next().getCollectionName();
        ArrayList<Object> ids = new ArrayList<Object>(refs.size());
        for (DBRef ref : refs) {
            if (!collection.equals(ref.getCollectionName())) {
                throw new InvalidDataAccessApiUsageException("DBRefs must all target the same collection for bulk fetch operation.");
            }
            ids.add(ref.getId());
        }
        DBRef databaseSource = refs.iterator().next();
        MongoCollection<Document> mongoCollection = this.getCollection(databaseSource);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Bulk fetching DBRefs {} from {}.{}.", new Object[]{ids, StringUtils.hasText((String)databaseSource.getDatabaseName()) ? databaseSource.getDatabaseName() : mongoCollection.getNamespace().getDatabaseName(), databaseSource.getCollectionName()});
        }
        List result = (List)mongoCollection.find((Bson)new Document("_id", (Object)new Document("$in", ids))).into(new ArrayList(ids.size()));
        return ids.stream().flatMap(id -> DefaultDbRefResolver.documentWithId(id, result)).collect(Collectors.toList());
    }

    private Object createLazyLoadingProxy(MongoPersistentProperty property, @Nullable DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Object lazyLoadingProxy = this.getProxyFactory().createLazyLoadingProxy(property, callback, dbref);
        return handler.populateId(property, dbref, lazyLoadingProxy);
    }

    private boolean isLazyDbRef(MongoPersistentProperty property) {
        return property.getDBRef() != null && property.getDBRef().lazy();
    }

    private static Stream<Document> documentWithId(Object identifier, Collection<Document> documents) {
        return documents.stream().filter(it -> it.get((Object)"_id").equals(identifier)).limit(1L);
    }

    protected MongoCollection<Document> getCollection(DBRef dbref) {
        return MongoDatabaseUtils.getDatabase(dbref.getDatabaseName(), this.mongoDbFactory).getCollection(dbref.getCollectionName(), Document.class);
    }

    protected MongoCollection<Document> getCollection(ReferenceResolver.ReferenceCollection context) {
        return MongoDatabaseUtils.getDatabase(context.getDatabase(), this.mongoDbFactory).getCollection(context.getCollection(), Document.class);
    }
}

