/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadPreference;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.Collection;
import java.util.function.Supplier;
import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.mongodb.core.ChangeStreamEvent;
import org.springframework.data.mongodb.core.ChangeStreamOptions;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.ReactiveCollectionCallback;
import org.springframework.data.mongodb.core.ReactiveDatabaseCallback;
import org.springframework.data.mongodb.core.ReactiveFluentMongoOperations;
import org.springframework.data.mongodb.core.ReactiveSessionScoped;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.ReactiveIndexOperations;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveMongoOperations
extends ReactiveFluentMongoOperations {
    public ReactiveIndexOperations indexOps(String var1);

    public ReactiveIndexOperations indexOps(Class<?> var1);

    public Mono<Document> executeCommand(String var1);

    public Mono<Document> executeCommand(Document var1);

    public Mono<Document> executeCommand(Document var1, @Nullable ReadPreference var2);

    public <T> Flux<T> execute(ReactiveDatabaseCallback<T> var1);

    public <T> Flux<T> execute(Class<?> var1, ReactiveCollectionCallback<T> var2);

    public <T> Flux<T> execute(String var1, ReactiveCollectionCallback<T> var2);

    default public ReactiveSessionScoped withSession(Supplier<ClientSession> sessionProvider) {
        Assert.notNull(sessionProvider, (String)"SessionProvider must not be null!");
        return this.withSession((Publisher<ClientSession>)Mono.fromSupplier(sessionProvider));
    }

    public ReactiveSessionScoped withSession(ClientSessionOptions var1);

    public ReactiveSessionScoped withSession(Publisher<ClientSession> var1);

    public ReactiveMongoOperations withSession(ClientSession var1);

    @Deprecated
    public ReactiveSessionScoped inTransaction();

    @Deprecated
    public ReactiveSessionScoped inTransaction(Publisher<ClientSession> var1);

    public <T> Mono<MongoCollection<Document>> createCollection(Class<T> var1);

    public <T> Mono<MongoCollection<Document>> createCollection(Class<T> var1, @Nullable CollectionOptions var2);

    public Mono<MongoCollection<Document>> createCollection(String var1);

    public Mono<MongoCollection<Document>> createCollection(String var1, CollectionOptions var2);

    public Flux<String> getCollectionNames();

    public Mono<MongoCollection<Document>> getCollection(String var1);

    public <T> Mono<Boolean> collectionExists(Class<T> var1);

    public Mono<Boolean> collectionExists(String var1);

    public <T> Mono<Void> dropCollection(Class<T> var1);

    public Mono<Void> dropCollection(String var1);

    public <T> Flux<T> findAll(Class<T> var1);

    public <T> Flux<T> findAll(Class<T> var1, String var2);

    public <T> Mono<T> findOne(Query var1, Class<T> var2);

    public <T> Mono<T> findOne(Query var1, Class<T> var2, String var3);

    public Mono<Boolean> exists(Query var1, String var2);

    public Mono<Boolean> exists(Query var1, Class<?> var2);

    public Mono<Boolean> exists(Query var1, @Nullable Class<?> var2, String var3);

    public <T> Flux<T> find(Query var1, Class<T> var2);

    public <T> Flux<T> find(Query var1, Class<T> var2, String var3);

    public <T> Mono<T> findById(Object var1, Class<T> var2);

    public <T> Mono<T> findById(Object var1, Class<T> var2, String var3);

    default public <T> Flux<T> findDistinct(String field, Class<?> entityClass, Class<T> resultClass) {
        return this.findDistinct(new Query(), field, entityClass, resultClass);
    }

    public <T> Flux<T> findDistinct(Query var1, String var2, Class<?> var3, Class<T> var4);

    public <T> Flux<T> findDistinct(Query var1, String var2, String var3, Class<?> var4, Class<T> var5);

    default public <T> Flux<T> findDistinct(Query query, String field, String collection, Class<T> resultClass) {
        return this.findDistinct(query, field, collection, Object.class, resultClass);
    }

    public <O> Flux<O> aggregate(TypedAggregation<?> var1, String var2, Class<O> var3);

    public <O> Flux<O> aggregate(TypedAggregation<?> var1, Class<O> var2);

    public <O> Flux<O> aggregate(Aggregation var1, Class<?> var2, Class<O> var3);

    public <O> Flux<O> aggregate(Aggregation var1, String var2, Class<O> var3);

    @Deprecated
    public <T> Flux<GeoResult<T>> geoNear(NearQuery var1, Class<T> var2);

    @Deprecated
    public <T> Flux<GeoResult<T>> geoNear(NearQuery var1, Class<T> var2, String var3);

    public <T> Mono<T> findAndModify(Query var1, UpdateDefinition var2, Class<T> var3);

    public <T> Mono<T> findAndModify(Query var1, UpdateDefinition var2, Class<T> var3, String var4);

    public <T> Mono<T> findAndModify(Query var1, UpdateDefinition var2, FindAndModifyOptions var3, Class<T> var4);

    public <T> Mono<T> findAndModify(Query var1, UpdateDefinition var2, FindAndModifyOptions var3, Class<T> var4, String var5);

    default public <T> Mono<T> findAndReplace(Query query, T replacement) {
        return this.findAndReplace(query, replacement, FindAndReplaceOptions.empty());
    }

    default public <T> Mono<T> findAndReplace(Query query, T replacement, String collectionName) {
        return this.findAndReplace(query, replacement, FindAndReplaceOptions.empty(), collectionName);
    }

    default public <T> Mono<T> findAndReplace(Query query, T replacement, FindAndReplaceOptions options) {
        return this.findAndReplace(query, replacement, options, this.getCollectionName(ClassUtils.getUserClass(replacement)));
    }

    default public <T> Mono<T> findAndReplace(Query query, T replacement, FindAndReplaceOptions options, String collectionName) {
        Assert.notNull(replacement, (String)"Replacement must not be null!");
        return this.findAndReplace(query, replacement, options, ClassUtils.getUserClass(replacement), collectionName);
    }

    default public <T> Mono<T> findAndReplace(Query query, T replacement, FindAndReplaceOptions options, Class<T> entityType, String collectionName) {
        return this.findAndReplace(query, replacement, options, entityType, collectionName, entityType);
    }

    default public <S, T> Mono<T> findAndReplace(Query query, S replacement, FindAndReplaceOptions options, Class<S> entityType, Class<T> resultType) {
        return this.findAndReplace(query, replacement, options, entityType, this.getCollectionName(ClassUtils.getUserClass(entityType)), resultType);
    }

    public <S, T> Mono<T> findAndReplace(Query var1, S var2, FindAndReplaceOptions var3, Class<S> var4, String var5, Class<T> var6);

    public <T> Mono<T> findAndRemove(Query var1, Class<T> var2);

    public <T> Mono<T> findAndRemove(Query var1, Class<T> var2, String var3);

    public Mono<Long> count(Query var1, Class<?> var2);

    public Mono<Long> count(Query var1, String var2);

    public Mono<Long> count(Query var1, @Nullable Class<?> var2, String var3);

    default public Mono<Long> estimatedCount(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.estimatedCount(this.getCollectionName(entityClass));
    }

    public Mono<Long> estimatedCount(String var1);

    default public Mono<Long> exactCount(Query query, Class<?> entityClass) {
        return this.exactCount(query, entityClass, this.getCollectionName(entityClass));
    }

    default public Mono<Long> exactCount(Query query, String collectionName) {
        return this.exactCount(query, null, collectionName);
    }

    public Mono<Long> exactCount(Query var1, @Nullable Class<?> var2, String var3);

    public <T> Mono<T> insert(T var1);

    public <T> Mono<T> insert(T var1, String var2);

    public <T> Flux<T> insert(Collection<? extends T> var1, Class<?> var2);

    public <T> Flux<T> insert(Collection<? extends T> var1, String var2);

    public <T> Flux<T> insertAll(Collection<? extends T> var1);

    public <T> Mono<T> insert(Mono<? extends T> var1);

    public <T> Flux<T> insertAll(Mono<? extends Collection<? extends T>> var1, Class<?> var2);

    public <T> Flux<T> insertAll(Mono<? extends Collection<? extends T>> var1, String var2);

    public <T> Flux<T> insertAll(Mono<? extends Collection<? extends T>> var1);

    public <T> Mono<T> save(T var1);

    public <T> Mono<T> save(T var1, String var2);

    public <T> Mono<T> save(Mono<? extends T> var1);

    public <T> Mono<T> save(Mono<? extends T> var1, String var2);

    public Mono<UpdateResult> upsert(Query var1, UpdateDefinition var2, Class<?> var3);

    public Mono<UpdateResult> upsert(Query var1, UpdateDefinition var2, String var3);

    public Mono<UpdateResult> upsert(Query var1, UpdateDefinition var2, Class<?> var3, String var4);

    public Mono<UpdateResult> updateFirst(Query var1, UpdateDefinition var2, Class<?> var3);

    public Mono<UpdateResult> updateFirst(Query var1, UpdateDefinition var2, String var3);

    public Mono<UpdateResult> updateFirst(Query var1, UpdateDefinition var2, Class<?> var3, String var4);

    public Mono<UpdateResult> updateMulti(Query var1, UpdateDefinition var2, Class<?> var3);

    public Mono<UpdateResult> updateMulti(Query var1, UpdateDefinition var2, String var3);

    public Mono<UpdateResult> updateMulti(Query var1, UpdateDefinition var2, Class<?> var3, String var4);

    public Mono<DeleteResult> remove(Object var1);

    public Mono<DeleteResult> remove(Object var1, String var2);

    public Mono<DeleteResult> remove(Mono<? extends Object> var1);

    public Mono<DeleteResult> remove(Mono<? extends Object> var1, String var2);

    public Mono<DeleteResult> remove(Query var1, Class<?> var2);

    public Mono<DeleteResult> remove(Query var1, @Nullable Class<?> var2, String var3);

    public Mono<DeleteResult> remove(Query var1, String var2);

    public <T> Flux<T> findAllAndRemove(Query var1, String var2);

    public <T> Flux<T> findAllAndRemove(Query var1, Class<T> var2);

    public <T> Flux<T> findAllAndRemove(Query var1, Class<T> var2, String var3);

    public <T> Flux<T> tail(Query var1, Class<T> var2);

    public <T> Flux<T> tail(Query var1, Class<T> var2, String var3);

    default public <T> Flux<ChangeStreamEvent<T>> changeStream(ChangeStreamOptions options, Class<T> targetType) {
        return this.changeStream(null, options, targetType);
    }

    default public <T> Flux<ChangeStreamEvent<T>> changeStream(@Nullable String collectionName, ChangeStreamOptions options, Class<T> targetType) {
        return this.changeStream(null, collectionName, options, targetType);
    }

    public <T> Flux<ChangeStreamEvent<T>> changeStream(@Nullable String var1, @Nullable String var2, ChangeStreamOptions var3, Class<T> var4);

    @Deprecated
    public <T> Flux<T> mapReduce(Query var1, Class<?> var2, Class<T> var3, String var4, String var5, MapReduceOptions var6);

    @Deprecated
    public <T> Flux<T> mapReduce(Query var1, Class<?> var2, String var3, Class<T> var4, String var5, String var6, MapReduceOptions var7);

    public MongoConverter getConverter();

    public String getCollectionName(Class<?> var1);
}

