/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.JsonSchemaMapper;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoJsonSchemaMapper
implements JsonSchemaMapper {
    private static final String $JSON_SCHEMA = "$jsonSchema";
    private static final String REQUIRED_FIELD = "required";
    private static final String PROPERTIES_FIELD = "properties";
    private static final String ENUM_FIELD = "enum";
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoConverter converter;

    public MongoJsonSchemaMapper(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null!");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    @Override
    public Document mapSchema(Document jsonSchema, Class<?> type) {
        Assert.notNull((Object)jsonSchema, (String)"Schema must not be null!");
        Assert.notNull(type, (String)"Type must not be null! Please consider Object.class.");
        Assert.isTrue((boolean)jsonSchema.containsKey((Object)$JSON_SCHEMA), () -> String.format("Document does not contain $jsonSchema field. Found %s.", jsonSchema));
        if (Object.class.equals(type)) {
            return new Document((Map)jsonSchema);
        }
        return new Document($JSON_SCHEMA, (Object)this.mapSchemaObject(this.mappingContext.getPersistentEntity(type), (Document)jsonSchema.get((Object)$JSON_SCHEMA, Document.class)));
    }

    private Document mapSchemaObject(@Nullable PersistentEntity<?, MongoPersistentProperty> entity, Document source) {
        Document sink = new Document((Map)source);
        if (source.containsKey((Object)REQUIRED_FIELD)) {
            sink.replace((Object)REQUIRED_FIELD, this.mapRequiredProperties(entity, (Collection)source.get((Object)REQUIRED_FIELD, Collection.class)));
        }
        if (source.containsKey((Object)PROPERTIES_FIELD)) {
            sink.replace((Object)PROPERTIES_FIELD, (Object)this.mapProperties(entity, (Document)source.get((Object)PROPERTIES_FIELD, Document.class)));
        }
        this.mapEnumValuesIfNecessary(sink);
        return sink;
    }

    private Document mapProperties(@Nullable PersistentEntity<?, MongoPersistentProperty> entity, Document source) {
        Document sink = new Document();
        for (String fieldName : source.keySet()) {
            String mappedFieldName = this.getFieldName(entity, fieldName);
            Document mappedProperty = this.mapProperty(entity, fieldName, (Document)source.get((Object)fieldName, Document.class));
            sink.append(mappedFieldName, (Object)mappedProperty);
        }
        return sink;
    }

    private List<String> mapRequiredProperties(@Nullable PersistentEntity<?, MongoPersistentProperty> entity, Collection<String> sourceFields) {
        return sourceFields.stream().map(fieldName -> this.getFieldName(entity, (String)fieldName)).collect(Collectors.toList());
    }

    private Document mapProperty(@Nullable PersistentEntity<?, MongoPersistentProperty> entity, String sourceFieldName, Document source) {
        MongoPersistentProperty property;
        Document sink = new Document((Map)source);
        if (entity != null && sink.containsKey((Object)JsonSchemaObject.Type.objectType().representation()) && (property = (MongoPersistentProperty)entity.getPersistentProperty(sourceFieldName)) != null && property.isEntity()) {
            sink = this.mapSchemaObject(this.mappingContext.getPersistentEntity(property.getActualType()), source);
        }
        return this.mapEnumValuesIfNecessary(sink);
    }

    private Document mapEnumValuesIfNecessary(Document source) {
        Document sink = new Document((Map)source);
        if (source.containsKey((Object)ENUM_FIELD)) {
            sink.replace((Object)ENUM_FIELD, this.mapEnumValues((Iterable)source.get((Object)ENUM_FIELD, Iterable.class)));
        }
        return sink;
    }

    private List<Object> mapEnumValues(Iterable<?> values) {
        ArrayList<Object> converted = new ArrayList<Object>();
        for (Object val : values) {
            converted.add(this.converter.convertToMongoType(val));
        }
        return converted;
    }

    private String getFieldName(@Nullable PersistentEntity<?, MongoPersistentProperty> entity, String sourceField) {
        if (entity == null) {
            return sourceField;
        }
        MongoPersistentProperty property = (MongoPersistentProperty)entity.getPersistentProperty(sourceField);
        return property != null ? property.getFieldName() : sourceField;
    }
}

