/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface Message<S, T> {
    @Nullable
    public S getRaw();

    @Nullable
    public T getBody();

    public MessageProperties getProperties();

    public static class MessageProperties {
        private static final MessageProperties EMPTY = new MessageProperties();
        @Nullable
        private String databaseName;
        @Nullable
        private String collectionName;

        @Nullable
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Nullable
        public String getCollectionName() {
            return this.collectionName;
        }

        public static MessageProperties empty() {
            return EMPTY;
        }

        public static MessagePropertiesBuilder builder() {
            return new MessagePropertiesBuilder();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageProperties that = (MessageProperties)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.databaseName, (Object)that.databaseName)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.collectionName, (Object)that.collectionName);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.databaseName);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.collectionName);
            return result;
        }

        public String toString() {
            return "Message.MessageProperties(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ")";
        }

        public static class MessagePropertiesBuilder {
            @Nullable
            private String databaseName;
            @Nullable
            private String collectionName;

            public MessagePropertiesBuilder databaseName(String dbName) {
                Assert.notNull((Object)dbName, (String)"Database name must not be null!");
                this.databaseName = dbName;
                return this;
            }

            public MessagePropertiesBuilder collectionName(String collectionName) {
                Assert.notNull((Object)collectionName, (String)"Collection name must not be null!");
                this.collectionName = collectionName;
                return this;
            }

            public MessageProperties build() {
                MessageProperties properties = new MessageProperties();
                properties.collectionName = this.collectionName;
                properties.databaseName = this.databaseName;
                return properties;
            }
        }
    }
}

