/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.reactivestreams.client.ClientSession;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;

class ReactiveMongoResourceHolder
extends ResourceHolderSupport {
    @Nullable
    private ClientSession session;
    private ReactiveMongoDatabaseFactory databaseFactory;

    ReactiveMongoResourceHolder(@Nullable ClientSession session, ReactiveMongoDatabaseFactory databaseFactory) {
        this.session = session;
        this.databaseFactory = databaseFactory;
    }

    @Nullable
    ClientSession getSession() {
        return this.session;
    }

    ClientSession getRequiredSession() {
        ClientSession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("No ClientSession associated");
        }
        return session;
    }

    public ReactiveMongoDatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public void setSession(@Nullable ClientSession session) {
        this.session = session;
    }

    boolean hasSession() {
        return this.session != null;
    }

    @Nullable
    public ClientSession setSessionIfAbsent(@Nullable ClientSession session) {
        if (!this.hasSession()) {
            this.setSession(session);
        }
        return session;
    }

    boolean hasActiveSession() {
        if (!this.hasSession()) {
            return false;
        }
        return this.hasServerSession() && !this.getRequiredSession().getServerSession().isClosed();
    }

    boolean hasActiveTransaction() {
        if (!this.hasActiveSession()) {
            return false;
        }
        return this.getRequiredSession().hasActiveTransaction();
    }

    boolean hasServerSession() {
        try {
            return this.getRequiredSession().getServerSession() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }
}

