/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert.encryption;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.Binary;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.convert.encryption.EncryptingConverter;
import org.springframework.data.mongodb.core.convert.encryption.ExplicitEncryptionContext;
import org.springframework.data.mongodb.core.encryption.Encryption;
import org.springframework.data.mongodb.core.encryption.EncryptionContext;
import org.springframework.data.mongodb.core.encryption.EncryptionKeyResolver;
import org.springframework.data.mongodb.core.encryption.EncryptionOptions;
import org.springframework.data.mongodb.core.mapping.Encrypted;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class MongoEncryptionConverter
implements EncryptingConverter<Object, Object> {
    private static final Log LOGGER = LogFactory.getLog(MongoEncryptionConverter.class);
    private final Encryption<BsonValue, BsonBinary> encryption;
    private final EncryptionKeyResolver keyResolver;

    public MongoEncryptionConverter(Encryption<BsonValue, BsonBinary> encryption, EncryptionKeyResolver keyResolver) {
        this.encryption = encryption;
        this.keyResolver = keyResolver;
    }

    @Override
    @Nullable
    public Object read(Object value, MongoConversionContext context) {
        Object decrypted = EncryptingConverter.super.read(value, context);
        return decrypted instanceof BsonValue ? BsonUtils.toJavaType((BsonValue)decrypted) : decrypted;
    }

    @Override
    public Object decrypt(Object encryptedValue, EncryptionContext context) {
        Object decryptedValue = encryptedValue;
        if (encryptedValue instanceof Binary || encryptedValue instanceof BsonBinary) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Decrypting %s.%s.", this.getProperty(context).getOwner().getName(), this.getProperty(context).getName()));
            }
            if (encryptedValue == (decryptedValue = this.encryption.decrypt((BsonBinary)BsonUtils.simpleToBsonValue(encryptedValue)))) {
                return decryptedValue;
            }
        }
        MongoPersistentProperty persistentProperty = this.getProperty(context);
        if (this.getProperty(context).isCollectionLike() && decryptedValue instanceof Iterable) {
            Collection collection;
            int size;
            Iterable iterable = (Iterable)decryptedValue;
            if (iterable instanceof Collection) {
                Collection c = (Collection)iterable;
                v0 = c.size();
            } else {
                v0 = size = 10;
            }
            if (!persistentProperty.isEntity()) {
                collection = CollectionFactory.createCollection((Class)persistentProperty.getType(), (int)size);
                iterable.forEach(it -> collection.add(BsonUtils.toJavaType((BsonValue)it)));
                return collection;
            }
            collection = CollectionFactory.createCollection((Class)persistentProperty.getType(), (int)size);
            iterable.forEach(it -> collection.add(context.read(BsonUtils.toJavaType((BsonValue)it), persistentProperty.getActualType())));
            return collection;
        }
        if (!persistentProperty.isEntity() && decryptedValue instanceof BsonValue) {
            BsonValue bsonValue = (BsonValue)decryptedValue;
            if (persistentProperty.isMap() && persistentProperty.getType() != Document.class) {
                return new LinkedHashMap((Document)BsonUtils.toJavaType(bsonValue));
            }
            return BsonUtils.toJavaType(bsonValue);
        }
        if (persistentProperty.isEntity() && decryptedValue instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)decryptedValue;
            return context.read(BsonUtils.toJavaType((BsonValue)bsonDocument), persistentProperty.getTypeInformation().getType());
        }
        return decryptedValue;
    }

    @Override
    public Object encrypt(Object value, EncryptionContext context) {
        MongoPersistentProperty persistentProperty;
        Encrypted annotation;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Encrypting %s.%s.", this.getProperty(context).getOwner().getName(), this.getProperty(context).getName()));
        }
        if ((annotation = (Encrypted)(persistentProperty = this.getProperty(context)).findAnnotation(Encrypted.class)) == null) {
            annotation = (Encrypted)persistentProperty.getOwner().findAnnotation(Encrypted.class);
        }
        if (annotation == null) {
            throw new IllegalStateException(String.format("Property %s.%s is not annotated with @Encrypted", this.getProperty(context).getOwner().getName(), this.getProperty(context).getName()));
        }
        EncryptionOptions encryptionOptions = new EncryptionOptions(annotation.algorithm(), this.keyResolver.getKey(context));
        if (!persistentProperty.isEntity()) {
            Object convertedMap;
            if (persistentProperty.isCollectionLike()) {
                return this.encryption.encrypt(this.collectionLikeToBsonValue(value, persistentProperty, context), encryptionOptions);
            }
            if (persistentProperty.isMap() && (convertedMap = context.write(value)) instanceof Document) {
                Document document = (Document)convertedMap;
                return this.encryption.encrypt((BsonValue)document.toBsonDocument(), encryptionOptions);
            }
            return this.encryption.encrypt(BsonUtils.simpleToBsonValue(value), encryptionOptions);
        }
        if (persistentProperty.isCollectionLike()) {
            return this.encryption.encrypt(this.collectionLikeToBsonValue(value, persistentProperty, context), encryptionOptions);
        }
        Object write = context.write(value);
        if (write instanceof Document) {
            Document doc = (Document)write;
            return this.encryption.encrypt((BsonValue)doc.toBsonDocument(), encryptionOptions);
        }
        return this.encryption.encrypt(BsonUtils.simpleToBsonValue(write), encryptionOptions);
    }

    private BsonValue collectionLikeToBsonValue(Object value, MongoPersistentProperty property, EncryptionContext context) {
        BsonArray bsonArray = new BsonArray();
        boolean isEntity = property.isEntity();
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            values.forEach(it -> {
                if (isEntity) {
                    Document document = (Document)context.write(it, property.getTypeInformation());
                    bsonArray.add((BsonValue)(document == null ? null : document.toBsonDocument()));
                } else {
                    bsonArray.add(BsonUtils.simpleToBsonValue(it));
                }
            });
        } else if (ObjectUtils.isArray((Object)value)) {
            for (Object o : ObjectUtils.toObjectArray((Object)value)) {
                if (isEntity) {
                    Document document = (Document)context.write(o, property.getTypeInformation());
                    bsonArray.add((BsonValue)(document == null ? null : document.toBsonDocument()));
                    continue;
                }
                bsonArray.add(BsonUtils.simpleToBsonValue(o));
            }
        }
        return bsonArray;
    }

    @Override
    public EncryptionContext buildEncryptionContext(MongoConversionContext context) {
        return new ExplicitEncryptionContext(context);
    }

    protected MongoPersistentProperty getProperty(EncryptionContext context) {
        return context.getProperty();
    }
}

