/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.lang.Nullable;

class AggregationOperationRenderer {
    static final AggregationOperationContext DEFAULT_CONTEXT = new NoOpAggregationOperationContext();

    AggregationOperationRenderer() {
    }

    static List<Document> toDocument(List<AggregationOperation> operations, AggregationOperationContext rootContext) {
        ArrayList<Document> operationDocuments = new ArrayList<Document>(operations.size());
        AggregationOperationContext contextToUse = rootContext;
        for (AggregationOperation operation : operations) {
            operationDocuments.addAll(operation.toPipelineStages(contextToUse));
            if (!(operation instanceof FieldsExposingAggregationOperation)) continue;
            FieldsExposingAggregationOperation exposedFieldsOperation = (FieldsExposingAggregationOperation)operation;
            ExposedFields fields = exposedFieldsOperation.getFields();
            if (operation instanceof FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation || exposedFieldsOperation.inheritsFields()) {
                contextToUse = contextToUse.inheritAndExpose(fields);
                continue;
            }
            contextToUse = fields.exposesNoFields() ? DEFAULT_CONTEXT : contextToUse.expose(fields);
        }
        return operationDocuments;
    }

    private static class NoOpAggregationOperationContext
    implements AggregationOperationContext {
        private NoOpAggregationOperationContext() {
        }

        @Override
        public Document getMappedObject(Document document, @Nullable Class<?> type) {
            return document;
        }

        @Override
        public ExposedFields.FieldReference getReference(Field field) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(field, true));
        }

        @Override
        public ExposedFields.FieldReference getReference(String name) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(new Fields.AggregationField(name), true));
        }
    }
}

